/*
 * Copyright (c) 2018-2019, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef _CNVMPLATFORM_HPP_
#define _CNVMPLATFORM_HPP_

#include <string>
#include <memory>
#include <atomic>

namespace nvsipl
{

class CNvMPlatform
{
 public:

    struct Configuration
    {
        std::string boardName;
        std::string deserName;
        float fps;
        float dutyCycle;
    };

    static CNvMPlatform* GetInstance();

    std::string GetPlatformName() const
    {
        return m_oConfiguration.boardName;
    }

    std::string GetDeserializerName() const
    {
        return m_oConfiguration.deserName;
    }

    const Configuration& GetConfig(void) const
    {
        return m_oConfiguration;
    }

    ~CNvMPlatform();

 private:

    CNvMPlatform(); // Private constructor
    std::atomic<bool> m_bInitialized;
    Configuration m_oConfiguration;
};

} // end of namespace nvsipl
#endif //_CNVMPLATFORM_HPP_
