/*
 * Copyright (c) 2015-2019, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */
#include <string.h>
#include "log_utils.h"
#include "dev_list.h"
#include "ref_max9286_96705_ar0231_rccb.h"
#include "ref_max96712_96705_ar0231_rccb.h"
#include "ref_max96712_96705_ar0144.h"
#include "ref_max96712_96759_constellation.h"
#include "ref_max96712_tpg.h"
#include "tpg.h"

ImgDevDriver *ImgGetDevice(char *moduleName)
{
    uint8_t i = 0;
    ImgDevDriver *devices[] = {
        GetDriver_ref_max9286_96705_ar0231rccb(),
        GetDriver_ref_max96712_96705_ar0231rccb(),
        GetDriver_ref_max96712_96705_ar0144(),
        GetDriver_ref_max96712_96759_constellation(),
        GetDriver_ref_max96712_tpg(),
        GetDriver_tpg()
    };

    if(!moduleName) {
        LOG_ERR("%s: Bad parameter for module name%s\n", __func__);
        return NULL;
    }

    for(i = 0; i < sizeof(devices) / sizeof(devices[0]); i++) {
        /* module name can have device name and version number,
         * so module name can be longer than device name.
         * therefore, comparing string needs length of the device name */
        if(!strncmp(moduleName, devices[i]->name, strlen(devices[i]->name))) {
            LOG_DBG("%s: Found the driver for %s\n", __func__, moduleName);
            return devices[i];
        }
    }

    LOG_ERR("%s: Can't find driver for %s\n", __func__, moduleName);

    return NULL;
};
