/*
 * Copyright (c) 2018-2020, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#include "CNvMMax96759.hpp"

extern "C" {
#include "cdi_max96759.h"
}

namespace nvsipl
{

SIPLStatus CNvMMax96759::SetConfig(const SerInfo *serializerInfo, DeviceParams *params)
{
    SIPLStatus status = NVSIPL_STATUS_OK;

    if (m_eState != CREATED) {
        LOG_ERR("CDI invalid state\n");
        return NVSIPL_STATUS_INVALID_STATE;
    }

    status = CNvMSerializer::SetConfig(serializerInfo, params);
    CHK_NVSIPLEERROR_AND_RETURN(status, "CNvMSerializer::SetConfig");

    /*! Get CDI Driver */
    m_pCDIDriver = GetMAX96759Driver();
    CHK_PTR_AND_RETURN(m_pCDIDriver, "GetMAX96759Driver() in CNvMMax96759::SetConfig");

    m_eState = CDI_DEVICE_CONFIG_SET;
    return NVSIPL_STATUS_OK;
}

} // end of nvsipl
