/*
 * Copyright (c) 2018-2020, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef _CNVMTRANSPORTINK_MAX96712_9295_HPP_
#define _CNVMTRANSPORTINK_MAX96712_9295_HPP_

#include "TransportLinkIF/CNvMTransportLink.hpp"

namespace nvsipl
{

class CNvMTransportLink_Max96712_9295: public CNvMTransportLink
{
public:
    SIPLStatus Init(DevBlkCDIDevice* brdcstSerCDI, uint8_t linkMask, bool groupInitProg) override;

    SIPLStatus PostSensorInit(DevBlkCDIDevice* brdcstSerCDI, uint8_t linkMask, bool groupInitProg) override;

    SIPLStatus MiscInit() override;

    bool IsGMSL2() override {return true;};

private:
    // Dump link Parameters
    void DumpLinkParams();

    // Setup address translations
    SIPLStatus SetupAddressTranslations(DevBlkCDIDevice* brdcstSerCDI);
};

} // end of namespace nvsipl
#endif // _CNVMTRANSPORTINK_MAX96712_9295_HPP_
