/* Copyright (c) 2015-2018, NVIDIA CORPORATION.  All rights reserved.
 *
 * NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited.
 */

#ifndef _SENSOR_INFO_OV10640_H_
#define _SENSOR_INFO_OV10640_H_

#include "sensor_info.h"

// Register addresses of OV10640 for exposure and gain calculations
#define OV10640_HTS_H           0x3080
#define OV10640_HTS_L           0x3081
#define OV10640_VTS_H           0x3082
#define OV10640_VTS_L           0x3083
#define OV10640_SCLK_PLL_PRE    0x3000
#define OV10640_SCLK_PLL_MULT   0x3001
#define OV10640_SCLK_PLL_POST   0x3002

// Exposure
#define OV10640_EXPO_L_H        0x30E6
#define OV10640_EXPO_L_L        0x30E7
#define OV10640_EXPO_S_H        0x30E8
#define OV10640_EXPO_S_L        0x30E9
#define OV10640_EXPO_VS         0x30EA

// Digital gain
#define OV10640_DGAIN_L_H       0x30EC
#define OV10640_DGAIN_L_L       0x30ED
#define OV10640_DGAIN_S_H       0x30EE
#define OV10640_DGAIN_S_L       0x30EF
#define OV10640_DGAIN_VS_H      0x30F0
#define OV10640_DGAIN_VS_L      0x30F1

// Analog and common gain
#define OV10640_CG_AGAIN        0x30EB
#define OV10640_R_GAIN_L_I_H    0x31C3

// compression mode: 10bit/12bit
#define OV10640_COMBINATN_MODE  0x31BE

//Capture-Input Format
#define OV10640_INTERFACE_CTRL  0x3119

// FUSE-ID
#define OV10640_SENSOR_FUSE_ID_SIZE   16

#define OV10640_NUM_REG_TO_READ         8
#define OV10640_MAX_EXPOSURES           3
#define OV10640_DATA_REG_LEN            1

static const float_t OV10640_DecompressionLutCurve[] =
{ 0.00000000, 0.00006104, 0.00012207, 0.00018311, 0.00024414, 0.00030518, 0.00036621, 0.00042725, 0.00048828, 0.00055313, 0.00061417, 0.00067520, 0.00073624, 0.00079727, 0.00085831, 0.00091934,
  0.00098038, 0.00104141, 0.00110245, 0.00116348, 0.00122452, 0.00128555, 0.00134659, 0.00140762, 0.00146866, 0.00152969, 0.00159454, 0.00165558, 0.00171661, 0.00177765, 0.00183868, 0.00189972,
  0.00198364, 0.00222778, 0.00247192, 0.00271606, 0.00296021, 0.00320435, 0.00344849, 0.00369263, 0.00393677, 0.00418091, 0.00442505, 0.00468445, 0.00492859, 0.00517273, 0.00541687, 0.00566101,
  0.00590515, 0.00614929, 0.00639343, 0.00663757, 0.00688171, 0.00712585, 0.00737000, 0.00761414, 0.00785828, 0.00810242, 0.00834656, 0.00859070, 0.00885010, 0.00909424, 0.00933838, 0.00958252,
  0.00982666, 0.01007080, 0.01031494, 0.01055908, 0.01080322, 0.01104736, 0.01129150, 0.01153564, 0.01177979, 0.01202393, 0.01226807, 0.01251221, 0.01275635, 0.01301575, 0.01325989, 0.01350403,
  0.01374817, 0.01399231, 0.01423645, 0.01448059, 0.01472473, 0.01496887, 0.01521301, 0.01545715, 0.01586914, 0.01684570, 0.01782227, 0.01879883, 0.01977539, 0.02075195, 0.02178955, 0.02276611,
  0.02374268, 0.02471924, 0.02569580, 0.02667236, 0.02764893, 0.02862549, 0.02960205, 0.03057861, 0.03155518, 0.03253174, 0.03350830, 0.03448486, 0.03546143, 0.03643799, 0.03741455, 0.03845215,
  0.03942871, 0.04040527, 0.04138184, 0.04235840, 0.04333496, 0.04431152, 0.04528809, 0.04626465, 0.04724121, 0.04821777, 0.04919434, 0.05017090, 0.05114746, 0.05212402, 0.05310059, 0.05407715,
  0.05511475, 0.05609131, 0.05706787, 0.05804443, 0.05902100, 0.05999756, 0.06097412, 0.06195068, 0.06640625, 0.07421875, 0.08203125, 0.08984375, 0.09765625, 0.10546875, 0.11328125, 0.12109375,
  0.12890625, 0.13720703, 0.14501953, 0.15283203, 0.16064453, 0.16845703, 0.17626953, 0.18408203, 0.19189453, 0.19970703, 0.20751953, 0.21533203, 0.22314453, 0.23095703, 0.23876953, 0.24658203,
  0.25439453, 0.26220703, 0.27050781, 0.27832031, 0.28613281, 0.29394531, 0.30175781, 0.30957031, 0.31738281, 0.32519531, 0.33300781, 0.34082031, 0.34863281, 0.35644531, 0.36425781, 0.37207031,
  0.37988281, 0.38769531, 0.39550781, 0.40380859, 0.41162109, 0.41943359, 0.42724609, 0.43505859, 0.44287109, 0.45068359, 0.45849609, 0.46630859, 0.47412109, 0.48193359, 0.48974609, 0.49755859,
  0.50537109, 0.51318359, 0.52099609, 0.52880859, 0.53710938, 0.54492188, 0.55273438, 0.56054688, 0.56835938, 0.57617188, 0.58398438, 0.59179688, 0.59960938, 0.60742188, 0.61523438, 0.62304688,
  0.63085938, 0.63867188, 0.64648438, 0.65429688, 0.66210938, 0.67041016, 0.67822266, 0.68603516, 0.69384766, 0.70166016, 0.70947266, 0.71728516, 0.72509766, 0.73291016, 0.74072266, 0.74853516,
  0.75634766, 0.76416016, 0.77197266, 0.77978516, 0.78759766, 0.79541016, 0.80371094, 0.81152344, 0.81933594, 0.82714844, 0.83496094, 0.84277344, 0.85058594, 0.85839844, 0.86621094, 0.87402344,
  0.88183594, 0.88964844, 0.89746094, 0.90527344, 0.91308594, 0.92089844, 0.92871094, 0.93701172, 0.94482422, 0.95263672, 0.96044922, 0.96826172, 0.97607422, 0.98388672, 0.99169922, 0.99951172
};

SensorInfo *GetSensorInfo_ov10640(void);

#endif /* SENSOR_INFO_OV10640_H_ */
