/*
 * Copyright (c) 2018, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef _ISC_MAX96759_SETTING_H_
#define _ISC_MAX96759_SETTING_H_

#include <stdint.h>

#define MAX96759_DISPLAY_NAME_OFFSET        0x48
#define MAX96759_DISPLAY_NAME_MAX_LENGTH    12
#define MAX96759_EDID_START_REGISTER        0x2E00
#define MAX96759_EDID_SIZE                  256
#define MAX96759_EDID_CHECKSUM_OFFSET       127

static const uint8_t max96759_default_edid[MAX96759_EDID_SIZE] = {
    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x04, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x00, 0x01, 0x04, 0xA2, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
    0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x78, 0x1E, 0x80, 0xA0, 0x70, 0xD4, 0x12, 0x40, 0x30, 0x20,
    0x36, 0x00, 0x40, 0x00, 0x20, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x97,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t max96759_pg_setting_1920x1236[] = {
    3, 0x01, 0xC8, 0xF3,
    3, 0x01, 0xC9, 0x20,
    3, 0x01, 0xCA, 0x00,
    3, 0x01, 0xCB, 0x00,
    3, 0x01, 0xCC, 0x00,
    3, 0x01, 0xCD, 0x00,
    3, 0x01, 0xCE, 0x28,
    3, 0x01, 0xCF, 0xA0,
    3, 0x01, 0xD0, 0x28,
    3, 0x01, 0xD1, 0x0D,
    3, 0x01, 0xD2, 0xC0,
    3, 0x01, 0xD3, 0x00,
    3, 0x01, 0xD4, 0xE3,
    3, 0x01, 0xD5, 0x30,
    3, 0x01, 0xD6, 0x08,
    3, 0x01, 0xD7, 0x00,
    3, 0x01, 0xD8, 0x00,
    3, 0x01, 0xD9, 0x20,
    3, 0x01, 0xDA, 0x04,
    3, 0x01, 0xDB, 0xF3,
    3, 0x01, 0xDC, 0x00,
    3, 0x01, 0xDD, 0xE3,
    3, 0x01, 0xDE, 0x80,
    3, 0x01, 0xDF, 0x07,
    3, 0x01, 0xE0, 0x80,
    3, 0x01, 0xE1, 0x00,
    3, 0x01, 0xE2, 0xA0,
    3, 0x01, 0xE3, 0x04,
    3, 0x01, 0xE4, 0xD4,
    3, 0x01, 0xE5, 0x02,
    3, 0x01, 0xE6, 0x03,
    3, 0x01, 0xE7, 0x00,
    3, 0x01, 0xE8, 0x04,
    3, 0x01, 0xE9, 0x00,
    3, 0x01, 0xEA, 0x08,
    3, 0x01, 0xEB, 0x80,
    3, 0x01, 0xEC, 0x50,
    3, 0x01, 0xED, 0xA0,
    3, 0x01, 0xEE, 0x50,
};

#endif /* _ISC_MAX96759_SETTING_H_ */