/*
 * Copyright (c) 2018-2019, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef _ISC_CONSTELLATION_H_
#define _ISC_CONSTELLATION_H_

#include "nvmedia_isc.h"

typedef struct {
    unsigned int configSetIdx;
    NvMediaISCModuleConfig moduleConfig;
} ContextConstellation;

NvMediaISCDeviceDriver *GetConstellationDriver(void);

NvMediaStatus
GetConstellationConfigSet(
    const char *resolution,
    NvMediaICPInputFormatType inputFormat,
    unsigned int framerate,
    unsigned int *configSet);

NvMediaStatus
ConstellationCheckPresence(
    NvMediaISCDevice *handle);

#endif /* _ISC_CONSTELLATION_H_ */
