/*
 * Copyright (c) 2019, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef _TESTSCISYNC_H_
#define _TESTSCISYNC_H_

#include "sciSync.h"
#include "nvscisync.h"

//! Class to test scisync mode

class TestSciSync final
{
public:
    TestSciSync(
        uint32_t dlaId,
        uint32_t numTasks,
        std::string profileName);

    ~TestSciSync();

    NvMediaStatus SetUp();

    NvMediaStatus RunTest();

protected:
    NvMediaStatus CreateSyncObjFromAttrList(
        NvSciSyncAttrList list1,
        NvSciSyncAttrList list2,
        NvSciSyncObj *syncOjb);

    inline void FreeSyncAttrList(NvSciSyncAttrList list) {
        if( list != nullptr) {
            NvSciSyncAttrListFree(list);
            list = nullptr;
        }
    }

private:
    uint32_t m_dlaId;

    uint32_t m_numTasks;

    std::string m_profileName;

    std::unique_ptr<ShareBuf> m_shareBuf;

    std::shared_ptr<CPUSignaler> m_spSig = nullptr;

    std::shared_ptr<DlaWorker> m_spDla = nullptr;

    std::shared_ptr<CPUWaiter> m_spWaiter = nullptr;

    NvSciSyncCpuWaitContext m_cpuWaitContext = nullptr;

    NvSciSyncModule m_module = nullptr;
};

#endif // _TESTSCISYNC_H_
