/*
 * Copyright (c) 2019, NVIDIA CORPORATION.  All rights reserved.
 *
 * NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited.
 */

#ifndef _CMDPARSER_H_
#define _CMDPARSER_H_

/* STL Headers */
#include <unistd.h>
#include <cstdbool>
#include <cstring>
#include <iostream>
#include <getopt.h>
#include <vector>
#include <iomanip>

#include "utils.h"

//! Command line parser class
//! Parse command line options

class CmdParser
{
 public:
    bool testRuntime = false;
    bool testSciSync = false;
    bool testPing = false;
    std::string loadableName = std::string();
    uint32_t dlaId = 0;
    uint32_t numTasks = 0;

    uint32_t verboseLevel;

    static void ShowUsage(void);

    int Parse(int argc, char* argv[]);

    void PrintArgs() const;
};

#endif // _CMDPARSER_H_
