/*
 * Copyright (c) 2018-2019, NVIDIA CORPORATION.  All rights reserved.
 *
 * NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited.
 */

#ifndef _CNVMI2CADDRMGR_HPP_
#define _CNVMI2CADDRMGR_HPP_

#include <cstdint>
#include <memory>
#include <vector>

#include "utils/utils.hpp"

namespace nvsipl
{

class CNvMI2CAddrMgr
{
public:
    //! Constructor
    CNvMI2CAddrMgr();

    //! Destructor
    ~CNvMI2CAddrMgr() {};

    //! All I2C devices must be registered before calling GetI2CAddr()
    void RegisterNativeI2CAddr(uint8_t nativeI2CAddr);

    //! Auto-gen i2c address based on the native address
    uint8_t GenerateI2CAddr(uint8_t nativeI2CAddr);

private:
    //! I2C address manager list
    std::vector<uint8_t> reservedI2CAddr;
};

} // end of namespace nvsipl
#endif //_CNVMI2CADDRMGR_HPP_
