/*
 * Copyright (c) 2018-2020, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#include <cstring>

#include "CNvMDeserializer.hpp"

namespace nvsipl
{

CNvMDeserializer::CNvMDeserializer()
{
    m_eInterface = {};
    m_ePhyMode = {};
    m_uMipiSpeed = 0;
}

SIPLStatus CNvMDeserializer::SetConfig(const DeserInfo *deserInfo, DeserializerParams *params)
{
    m_eInterface = params->eInterface;
    m_ePhyMode = params->ePhyMode;
    m_ovLinkModes = params->ovLinkModes;

    m_uMipiSpeed = 0;
    m_oDeviceParams = params->oDeviceParams;
    m_linkMask = params->linkMask;

    for (uint8_t i = 0; i < MAX_CAMERAMODULES_PER_BLOCK; i++) {
        m_longCables[i] = params->longCables[i];
    }

    if (!m_oDeviceParams.bEnableSimulator) {
        m_nativeI2CAddr =  deserInfo->i2cAddress;
        m_oDeviceParams.pI2CAddrMgr->RegisterNativeI2CAddr(m_nativeI2CAddr);
    }

    return NVSIPL_STATUS_OK;
}

SIPLStatus CNvMDeserializer::DetectErrors(std::uint8_t& cameraModules)
{
    LOG_ERR("Error detection is not supported for this deserializer in CNvMDeserializer::DetectError\n");

    return NVSIPL_STATUS_NOT_SUPPORTED;
}

std::uint32_t CNvMDeserializer::GetMipiSpeed()
{
    if (m_eState != CDI_DEVICE_CONFIG_SET) {
        LOG_ERR("CDI device invalid state\n");
        return NVSIPL_STATUS_INVALID_STATE;
    }

    return m_uMipiSpeed;
}

} // end of nvsipl
