/*
 * Copyright (c) 2017-2020, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */
#ifndef _AR0144_SETTING_H_
#define _AR0144_SETTING_H_

#define AR0144_HTS                  1488u
#define AR0144_VTS                  825u
#define AR0144_VTS_30FPS            1648u
#define AR0144_PCLK                 74250000  // Hz

static const unsigned char ar0144_default[] = {
    'd', 0x4E, 0x20,
    'w', 4, 0x30, 0x1A, 0x00, 0xD9, /* RESET_REGISTER */
    'd', 0x4E, 0x20,
    'w', 4, 0x30, 0x1A, 0x30, 0xD8, /* RESET_REGISTER */
    'd', 0x4E, 0x20,
    'w', 4, 0x30, 0x88, 0x80, 0x00, /* SEQ_CTRL_PORT */
    'w', 4, 0x30, 0x86, 0x32, 0x7F, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x57, 0x80, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x27, 0x30, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x7E, 0x13, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x80, 0x00, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x15, 0x7E, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x13, 0x80, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x00, 0x0F, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x81, 0x90, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x16, 0x43, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x16, 0x3E, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x45, 0x22, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x09, 0x37, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x81, 0x90, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x16, 0x43, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x16, 0x7F, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x90, 0x80, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x00, 0x38, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x7F, 0x13, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x80, 0x23, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x3B, 0x7F, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x93, 0x45, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x02, 0x80, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x00, 0x7F, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0xB0, 0x8D, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x66, 0x7F, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x90, 0x81, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x92, 0x3C, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x16, 0x35, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x7F, 0x93, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x45, 0x02, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x80, 0x00, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x7F, 0xB0, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x8D, 0x66, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x7F, 0x90, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x81, 0x82, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x37, 0x45, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x02, 0x36, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x81, 0x80, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x44, 0x16, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x31, 0x43, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x74, 0x16, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x78, 0x7B, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x7D, 0x45, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x02, 0x3D, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x64, 0x45, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x0A, 0x3D, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x64, 0x7E, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x12, 0x81, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x80, 0x37, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x7F, 0x10, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x45, 0x0A, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x3F, 0x74, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x7E, 0x10, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x7E, 0x12, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x0F, 0x3D, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0xD2, 0x7F, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0xD4, 0x80, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x24, 0x82, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x9C, 0x03, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x43, 0x0D, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x2D, 0x46, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x43, 0x16, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x5F, 0x16, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x53, 0x2D, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x16, 0x60, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x40, 0x4C, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x29, 0x04, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x29, 0x84, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x81, 0xE7, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x81, 0x6F, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x17, 0x0A, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x81, 0xE7, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x7F, 0x81, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x5C, 0x0D, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x57, 0x49, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x5F, 0x53, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x25, 0x53, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x27, 0x4D, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x2B, 0xF8, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x10, 0x16, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x4C, 0x09, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x2B, 0xB8, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x2B, 0x98, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x4E, 0x11, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x53, 0x67, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x40, 0x01, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x60, 0x5C, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x09, 0x5C, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x1B, 0x40, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x02, 0x45, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x00, 0x45, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x80, 0x29, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0xB6, 0x7F, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x80, 0x40, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x04, 0x7F, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x88, 0x41, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x09, 0x5C, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x0B, 0x29, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0xB2, 0x41, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x0C, 0x40, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x03, 0x40, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x13, 0x5C, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x03, 0x41, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x11, 0x17, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x12, 0x5F, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x2B, 0x90, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x2B, 0x80, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x81, 0x6F, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x40, 0x10, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x41, 0x01, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x53, 0x27, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x40, 0x01, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x60, 0x29, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0xA3, 0x5F, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x4D, 0x1C, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x17, 0x02, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x81, 0xE7, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x29, 0x83, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x45, 0x88, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x40, 0x21, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x7F, 0x8A, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x40, 0x39, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x45, 0x80, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x24, 0x40, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x08, 0x7F, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x88, 0x5D, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x53, 0x67, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x29, 0x92, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x88, 0x10, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x2B, 0x04, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x89, 0x16, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x5C, 0x43, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x86, 0x17, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x0B, 0x5C, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x03, 0x8A, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x48, 0x4D, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x4E, 0x2B, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x80, 0x4C, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x0B, 0x41, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x9F, 0x81, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x6F, 0x41, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x10, 0x40, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x01, 0x53, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x27, 0x40, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x01, 0x60, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x29, 0x83, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x29, 0x43, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x5C, 0x05, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x5F, 0x4D, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x1C, 0x81, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0xE7, 0x45, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x02, 0x81, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x80, 0x7F, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x80, 0x41, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x0A, 0x91, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x44, 0x16, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x09, 0x2F, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x7E, 0x37, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x80, 0x20, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x30, 0x7E, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x37, 0x80, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x20, 0x15, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x7E, 0x37, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x80, 0x20, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x03, 0x43, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x16, 0x4A, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x0A, 0x43, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x16, 0x0B, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x43, 0x16, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x8F, 0x43, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x16, 0x90, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x43, 0x16, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x7F, 0x81, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x45, 0x0A, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x41, 0x30, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x7F, 0x83, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x5D, 0x29, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x44, 0x88, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x10, 0x2B, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x04, 0x53, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x2D, 0x40, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x30, 0x45, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x02, 0x40, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x08, 0x7F, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x80, 0x53, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x2D, 0x89, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x16, 0x5C, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x45, 0x86, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x17, 0x0B, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x5C, 0x05, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x8A, 0x60, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x4B, 0x91, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x44, 0x16, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x09, 0x15, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x3D, 0xFF, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x3D, 0x87, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x7E, 0x3D, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x7E, 0x19, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x80, 0x00, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x8B, 0x1F, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x2A, 0x1F, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x83, 0xA2, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x7E, 0x11, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x75, 0x16, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x33, 0x45, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x0A, 0x7F, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x53, 0x80, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x23, 0x8C, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x66, 0x7F, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x13, 0x81, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x84, 0x14, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x81, 0x80, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x31, 0x3D, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x64, 0x45, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x2A, 0x3D, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0xD2, 0x7F, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x44, 0x80, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x24, 0x94, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x3D, 0xFF, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x3D, 0x4D, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x45, 0x02, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x7F, 0xD0, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x80, 0x00, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x8C, 0x66, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x7F, 0x90, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x81, 0x94, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x3F, 0x44, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x16, 0x81, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x84, 0x16, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x2C, 0x2C, /* SEQ_DATA_PORT */
    'w', 4, 0x30, 0x86, 0x2C, 0x2C, /* SEQ_DATA_PORT */
    'w', 4, 0x3E, 0xD6, 0x3C, 0xB5, /* RESERVED_MFR_3ED6 */
    'w', 4, 0x3E, 0xD8, 0x87, 0x65, /* RESERVED_MFR_3ED8 */
    'w', 4, 0x3E, 0xDA, 0x88, 0x88, /* RESERVED_MFR_3EDA */
    'w', 4, 0x3E, 0xDC, 0x97, 0xFF, /* RESERVED_MFR_3EDC */
    'w', 4, 0x3E, 0xF8, 0x65, 0x22, /* RESERVED_MFR_3EF8 */
    'w', 4, 0x3E, 0xFA, 0x22, 0x22, /* RESERVED_MFR_3EFA */
    'w', 4, 0x3E, 0xFC, 0x66, 0x66, /* RESERVED_MFR_3EFC */
    'w', 4, 0x3F, 0x00, 0xAA, 0x05, /* RESERVED_MFR_3F00 */
    'w', 4, 0x3E, 0xE2, 0x18, 0x0E, /* RESERVED_MFR_3EE2 */
    'w', 4, 0x3E, 0xE4, 0x08, 0x08, /* RESERVED_MFR_3EE4 */
    'w', 4, 0x3E, 0xEA, 0x2A, 0x09, /* RESERVED_MFR_3EEA */
    'w', 4, 0x30, 0x60, 0x00, 0x0D, /* ANALOG_GAIN */
    'w', 4, 0x30, 0x92, 0x00, 0xCF, /* RESERVED_MFR_3092 */
    'w', 4, 0x32, 0x68, 0x00, 0x30, /* RESERVED_MFR_3268 */
    'w', 4, 0x37, 0x86, 0x00, 0x06, /* DIGITAL_CTRL_1 */
    'w', 4, 0x3F, 0x4A, 0x0F, 0x70, /* RESERVED_MFR_3F4A */
    'w', 4, 0x30, 0x6E, 0x48, 0x10, /* DATAPATH_SELECT */
    'w', 4, 0x30, 0x64, 0x18, 0x02, /* SMIA_TEST */
    'w', 4, 0x3E, 0xF6, 0x80, 0x4D, /* RESERVED_MFR_3EF6 */
    'w', 4, 0x31, 0x80, 0xC0, 0x8F, /* DELTA_DK_CONTROL */
    'w', 4, 0x30, 0xBA, 0x76, 0x23, /* DIGITAL_CTRL */
    'w', 4, 0x31, 0x76, 0x04, 0x80, /* RESERVED_MFR_3176 */
    'w', 4, 0x31, 0x78, 0x04, 0x80, /* RESERVED_MFR_3178 */
    'w', 4, 0x31, 0x7A, 0x04, 0x80, /* RESERVED_MFR_317A */
    'w', 4, 0x31, 0x7C, 0x04, 0x80, /* RESERVED_MFR_317C */
    'w', 4, 0x30, 0x2A, 0x00, 0x06, /* VT_PIX_CLK_DIV */
    'w', 4, 0x30, 0x2C, 0x00, 0x01, /* VT_SYS_CLK_DIV */
    'w', 4, 0x30, 0x2E, 0x00, 0x04, /* PRE_PLL_CLK_DIV */
    'w', 4, 0x30, 0x30, 0x00, 0x42, /* PLL_MULTIPLIER */
    'w', 4, 0x30, 0x36, 0x00, 0x0C, /* OP_PIX_CLK_DIV */
    'w', 4, 0x30, 0x38, 0x00, 0x01, /* OP_SYS_CLK_DIV */
    'w', 4, 0x30, 0xCE, 0x01, 0x30, /* Reserved */
    'w', 4, 0x30, 0xB0, 0x01, 0x38, /* DIGITAL_TEST */
    'd', 0x27, 0x10,
    'w', 4, 0x30, 0x02, 0x00, 0x00, /* Y_ADDR_START */
    'w', 4, 0x30, 0x04, 0x00, 0x04, /* X_ADDR_START */
    'w', 4, 0x30, 0x06, 0x03, 0x1F, /* Y_ADDR_END */
    'w', 4, 0x30, 0x08, 0x05, 0x03, /* X_ADDR_END */
    'w', 4, 0x30, 0x0A, 0x03, 0x39, /* FRAME_LENGTH_LINES */
    'w', 4, 0x30, 0x0C, 0x05, 0xD0, /* LINE_LENGTH_PCK */
    'w', 4, 0x30, 0x12, 0x00, 0x64, /* COARSE_INTEGRATION_TIME - 2ms */
    'w', 4, 0x30, 0xA2, 0x00, 0x01, /* X_ODD_INC */
    'w', 4, 0x30, 0xA6, 0x00, 0x01, /* Y_ODD_INC */
    'w', 4, 0x30, 0x40, 0x00, 0x00, /* READ_MODE */
    'w', 4, 0x31, 0xAE, 0x02, 0x00, /* SERIAL_FORMAT */
    'w', 4, 0x30, 0x64, 0x19, 0x82, /* SMIA_TEST */
    'w', 4, 0x32, 0x70, 0x01, 0x00, /* LED_FLASH_CONTROL */
    'w', 4, 0x31, 0x00, 0x00, 0x01, /* AECTRLREG */
    'w', 4, 0x31, 0x02, 0x80, 0x00, /* AE_LUMA_TARGET_REG */
    'w', 4, 0x31, 0x1C, 0x00, 0x64, /* AE_MAX_EXPOSURE_REG */
    'w', 4, 0x31, 0x1E, 0x00, 0x01, /* AE_MIN_EXPOSURE_REG */
    'w', 4, 0x30, 0x28, 0x00, 0x10, /* ROW_SPEED */
    'w', 4, 0x30, 0xB4, 0x00, 0x11, /* TEMPSENS_CTRL_REG */
    'e'
};

static const unsigned char AR0144_enable_streaming[] = {
    'w', 4, 0x30, 0x1A, 0x39, 0xDC, /* RESET_REGISTER, Enable trigger mode */
    'e'
};

static const unsigned char AR0144_enable_pg[] = {
    'w', 4, 0x30, 0x70, 0x00, 0x02, /* Enable pattern generator */
    'e'
};

static const unsigned char AR0144_disable_emb_data[] = {
    'w', 4, 0x30, 0x64, 0x18, 0x02, /* Disable EMB_DATA */
    'e'
};

static const unsigned char AR0144_config_30fps[] = {
    'w', 4, 0x30, 0x0A, 0x06, 0x70, /* FRAME_LENGTH_LINES  for 30 fps*/
    'e'
};
#endif /* _AR0144_SETTING_H_ */
