/* Copyright (c) 2018-2020, NVIDIA CORPORATION.  All rights reserved.
 *
 * NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited.
 */

#ifndef _UTILS_H_
#define _UTILS_H_

#include "context.h"

#define MAX_EEPROM_SIZE 8192

NvMediaStatus
InitializeExtImgDevice(
    NvEEPROMContext *context);

void
DeinitializeExtImgDevice(
    NvEEPROMContext *context);

NvMediaStatus
ReadImageFromFile(
    const char *filename,
    uint8_t *buffer,
    uint32_t *size);

void
HostToEEPROMU16 (
    const uint16_t *src,
    uint8_t *dst,
    uint32_t count);

void
HostToEEPROMU32 (
    const uint32_t *src,
    uint8_t *dst,
    uint32_t count);

void
HostToEEPROMU64 (
    const uint64_t *src,
    uint8_t *dst,
    uint32_t count);

void
HostToEEPROMFloat (
    const float *src,
    uint8_t *dst,
    uint32_t count);

void
EEPROMToHostU16 (
    const uint8_t *src,
    uint16_t *dst,
    uint32_t count);

void
EEPROMToHostU32 (
    const uint8_t *src,
    uint32_t *dst,
    uint32_t count);

void
EEPROMToHostU64 (
    const uint8_t *src,
    uint64_t *dst,
    uint32_t count);

void
EEPROMToHostFloat (
    const uint8_t *src,
    float *dst,
    uint32_t count);

NvMediaStatus
EEPROMToHostFixed(
    const uint8_t * buffer,
    float *dst,
    uint32_t count,
    uint8_t *format);

#endif /* _UTILS_H_ */