/*
 * Copyright (c) 2019, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#include <iostream>
#include <fstream>
#include <sstream>
#include <cstring>

#include "utils.h"

uint8_t *
readFileToMemory(
    std::string fileName,
    uint64_t &fileSize
)
{
    char *pBuffer {nullptr};

    std::ifstream is(fileName, std::ifstream::binary | std::ios::ate);
    CHECK_FAIL(is, "Open filename = %s", fileName.c_str());

    fileSize = is.tellg();

    pBuffer = new char[fileSize];
    CHECK_FAIL(pBuffer != nullptr, "alloc buffer");

    is.seekg (0, is.beg);

    is.read(pBuffer, fileSize);

fail:
    return reinterpret_cast<uint8_t *>(pBuffer);
}
