/*
 * Copyright (c) 2018-2020, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#include "CNvMSerializer.hpp"

namespace nvsipl
{

SIPLStatus CNvMSerializer::SetConfig(const SerInfo *serializerInfo, DeviceParams *params)
{
    m_oDeviceParams = *params;

    if (!m_oDeviceParams.bEnableSimulator and !m_oDeviceParams.bSlave) {
        m_nativeI2CAddr =  serializerInfo->i2cAddress;
        m_oDeviceParams.pI2CAddrMgr->RegisterNativeI2CAddr(m_nativeI2CAddr);
    }

    return NVSIPL_STATUS_OK;
}

} // end of nvsipl
