/*
 * Copyright (c) 2018-2020, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef _CDI_CONSTELLATION_H_
#define _CDI_CONSTELLATION_H_

#include "devblk_cdi.h"

typedef struct {
    unsigned int configSetIdx;
    DevBlkCDIModuleConfig moduleConfig;
} ContextConstellation;

DevBlkCDIDeviceDriver *GetConstellationDriver(void);

NvMediaStatus
GetConstellationConfigSet(
    const char *resolution,
    NvMediaICPInputFormatType inputFormat,
    unsigned int framerate,
    int *configSet);

NvMediaStatus
ConstellationCheckPresence(
    DevBlkCDIDevice *handle);

#endif /* _CDI_CONSTELLATION_H_ */
