/* Copyright (c) 2018-2020, NVIDIA CORPORATION.  All rights reserved.
 *
 * NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited.
 */

#include <string.h>

#include "cmdline.h"
#include "context.h"
#include "dump.h"

int main(int argc,
         char *argv[])
{
    TestArgs allArgs;
    NvEEPROMContext context;
    NvMediaStatus status;

    memset(&allArgs, 0, sizeof(TestArgs));
    memset(&context, 0 , sizeof(NvEEPROMContext));

    if (NVMEDIA_STATUS_OK != ParseArgs(argc, argv, &allArgs)) {
        return -1;
    }

    context.allArgs = &allArgs;

    status = DumpEEPROM(&context);
    if (NVMEDIA_STATUS_OK != status) {
        return -1;
    }

    return 0;
}

void
PrintUsage(void)
{
    LOG_MSG("Usage: nvmeeprom_dump [options]\n");
    LOG_MSG("\nAvailable command line options:\n");
    LOG_MSG("-h                Print usage\n");
    LOG_MSG("-v [level]        Logging Level. Default = 0\n");
    LOG_MSG("                  0: Errors, 1: Warnings, 2: Info, 3: Debug\n");
    LOG_MSG("                  Default: 0\n");
    LOG_MSG("-n [sensors]      Number of camera devices to dump\n");
    LOG_MSG("-of [file-prefix] Dump the contents of the image devices to files with the\n");
    LOG_MSG("                  given prefix instead of printing\n");
    LOG_MSG("-cf [file]        Set configuration file.\n");
    LOG_MSG("                  Default: configs/default.conf\n");
    LOG_MSG("-c [name]         Parameters set name to be used for capture configuration.\n");
    LOG_MSG("                  Default: First config set (capture-params-set)\n");
    LOG_MSG("-lc               List all available config sets.\n");
    LOG_MSG("-a [address]      Provide the I2C address of the EEPROM.\n");
    LOG_MSG("--all             Print the entire EEPROM contents.\n");
}
