/*
 * Copyright (c) 2017, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef _NVMEDIA_TEST_CMD_LINE_H_
#define _NVMEDIA_TEST_CMD_LINE_H_

/* Include header containing NvMediaLDC declarations */
#include "nvmedia_ldc.h"

/* Maximum length of the path including file name */
#define FILE_NAME_SIZE 1024

/* TestArgs contains all arguments and variables required to run the LDC test */
typedef struct _TestArgs {
    int logLevel;

    /* NvMediaLDC Configuration*/
    /* see nvmedia_ldc.h for details */
    uint16_t srcWidth;
    uint16_t srcHeight;
    NvMediaRect srcRect;
    uint16_t dstWidth;
    uint16_t dstHeight;
    NvMediaRect dstRect;
    NvMediaLDCInitParams initParams;
    NvMediaLDCSparseWarpMap SparseWarpMap;
    NvMediaLDCCtrlParams ldcCtrlParams;

    char SparseWarpMapFile[FILE_NAME_SIZE];
    char bitMaskFile[FILE_NAME_SIZE];
    char infile[FILE_NAME_SIZE];
    char outfile[FILE_NAME_SIZE];
    char xsobelfile[FILE_NAME_SIZE];
    char downsamplefile[FILE_NAME_SIZE];
    uint16_t subSampling; /* sub-sampling type of input surfaces */
    uint16_t bitsPerComponent; /* bits per component for input/output surfaces */
    uint16_t UVorder; /* UV order */
    uint32_t numFrames;
    uint16_t xSobelWidth;
    uint16_t xSobelHeight;
    NvMediaBool bUpdateTNR3Params;
} TestArgs;

/* PrintUsage()  Prints application usage options */
void PrintUsage(void);

/* ParseArgs()  Parses command line arguments.
 * Also parses any configuration files supplied in the command line arguments.
* Arguments:
* argc
*    (in) Number of tokens in the command line
* argv
*    (in) Command line tokens
* args
*    (out) Pointer to test arguments structure
*/
int  ParseArgs(int argc, char **argv, TestArgs *args);

#endif /* _NVMEDIA_TEST_CMD_LINE_H_ */
