/*
 * Copyright (c) 2018-2019, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef _ISC_MAX96759_H_
#define _ISC_MAX96759_H_

#include "nvmedia_isc.h"

#define MAX96759_MAX_REG_ADDRESS        0x2EFF

#define MAX96759_MAX_BPP                24

typedef enum {
    ISC_CONFIG_MAX96759_SET_ONESHOT_RESET = 0,
    ISC_CONFIG_MAX96759_SET_RESET,
    ISC_CONFIG_MAX96759_SETUP_DUAL_VIEW,
    ISC_CONFIG_MAX96759_ENABLE_EXT_FRAME_SYNC,
} ConfigSetsMAX96759;

typedef enum {
    ISC_WRITE_PARAM_CMD_MAX96759_SET_DEVICE_ADDRESS = 0,
    ISC_WRITE_PARAM_CMD_MAX96759_SET_TRANSLATOR_A,
    ISC_WRITE_PARAM_CMD_MAX96759_SET_TRANSLATOR_B,
    ISC_WRITE_PARAM_CMD_MAX96759_SET_EDID,
    ISC_WRITE_PARAM_CMD_MAX96759_SET_LINK_MODE,
    ISC_WRITE_PARAM_CMD_MAX96759_SET_BPP,
    ISC_WRITE_PARAM_CMD_MAX96759_SET_TPG,
} WriteParametersCmdMAX96759;

typedef enum {
    ISC_READ_PARAM_CMD_MAX96759_REV_ID = 0,
} ReadParametersCmdMAX96759;

typedef enum {
    LINK_MODE_MAX96759_AUTO = 0,
    LINK_MODE_MAX96759_SPLITTER,
    LINK_MODE_MAX96759_DUAL,
    LINK_MODE_MAX96759_LINK_A,
    LINK_MODE_MAX96759_LINK_B,
} LinkModeMax96759;

typedef enum {
    ISC_MAX96777_REV_3 = 0,
    ISC_MAX96777_REV_4,
    ISC_MAX96759_REV_5,
    ISC_MAX96759_REV_7,
    ISC_MAX96777_MAX96759_INVALID_REV,
} RevisionMax96777Max96759;

typedef struct {
    union {
        struct {
            unsigned char source;
            unsigned char destination;
        } Translator;

        struct {
            unsigned char address;
        } DeviceAddress;

        struct {
            uint32_t height;
            uint32_t width;
            uint32_t frameRate;
            const char *identifier;
        } EDID;

        struct {
            uint32_t height;
            uint32_t width;
            uint32_t frameRate;
        } TPG;

        struct {
            LinkModeMax96759 mode;
        } LinkMode;

        uint8_t BitsPerPixel;

        RevisionMax96777Max96759 Revision;
    };
} ReadWriteParams96759;

typedef struct {
    RevisionMax96777Max96759 revision;         /* chip revision information */
} ContextMAX96759;

NvMediaISCDeviceDriver *GetMAX96759Driver(void);

NvMediaStatus
MAX96759CheckPresence(
    NvMediaISCDevice *handle);

NvMediaStatus
MAX96759SetDefaults(
    NvMediaISCDevice *handle);

NvMediaStatus
MAX96759SetDeviceConfig(
    NvMediaISCDevice *handle,
    uint32_t enumeratedDeviceConfig);

NvMediaStatus
MAX96759ReadRegister(
    NvMediaISCDevice *handle,
    uint32_t deviceIndex,
    uint32_t registerNum,
    uint32_t dataLength,
    uint8_t *dataBuff);

NvMediaStatus
MAX96759WriteRegister(
    NvMediaISCDevice *handle,
    uint32_t deviceIndex,
    uint32_t registerNum,
    uint32_t dataLength,
    uint8_t *dataBuff);

NvMediaStatus
MAX96759WriteParameters(
    NvMediaISCDevice *handle,
    uint32_t parameterType,
    uint32_t parameterSize,
    void *parameter);

NvMediaStatus
MAX96759ReadParameters(
    NvMediaISCDevice *handle,
    uint32_t parameterType,
    uint32_t parameterSize,
    void *parameter);

NvMediaStatus
MAX96759DumpRegisters(
    NvMediaISCDevice *handle);

#endif /* _ISC_MAX96759_H_ */
