/*
 * Copyright (c) 2019-2020, NVIDIA CORPORATION.  All rights reserved.
 *
 * NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited.
 */

#include "CNvMMAX96712_96759_Constellation.hpp"
#include "cameramodule/MAX96712cameramodule/CNvMTransportLink_Max96712_96759.hpp"
#include "ModuleIF/CNvMCameraModuleExport.hpp"

extern "C" {
#include "cdi_constellation.h"
}

#define OSC_MHZ 27

namespace nvsipl
{

SIPLStatus CNvMMAX96712_96759_Constellation::SetConfigModule(const SensorInfo *sensorInfo, CNvMDevice::DeviceParams *params) {

    // TODO: Add a check to verify this assumption
    auto& sensor = m_upSensor;
    std::string resolution;
    NvMediaStatus nvmediaStatus = NVMEDIA_STATUS_OK;

    resolution = std::to_string(sensor->GetWidth()) + "x" +  std::to_string(sensor->GetHeight());
    nvmediaStatus = GetConstellationConfigSet((char *)resolution.c_str(),
                                              sensorInfo->vcInfo.inputFormat,
                                              (uint32_t)sensor->GetFrameRate(),
                                              &m_ConfigIndex);
    CHK_NVMERROR_CONVERT_AND_RETURN(nvmediaStatus, "%s: Failed to get config");

    return NVSIPL_STATUS_OK;
}

SIPLStatus CNvMMAX96712_96759_Constellation::DetectModule() {
    return NVSIPL_STATUS_OK;
}

SIPLStatus CNvMMAX96712_96759_Constellation::InitModule() {
    return NVSIPL_STATUS_OK;
}

SIPLStatus CNvMMAX96712_96759_Constellation::StartModule() {
    return NVSIPL_STATUS_OK;
}

SIPLStatus CNvMMAX96712_96759_Constellation::StopModule() {
    return NVSIPL_STATUS_OK;
}

SIPLStatus CNvMMAX96712_96759_Constellation::DeinitModule() {
    return NVSIPL_STATUS_OK;
}

DevBlkCDIDeviceDriver *CNvMMAX96712_96759_Constellation::GetCDIDeviceDriver() {
    return GetConstellationDriver();
}

std::unique_ptr<CNvMDevice::DriverContext> CNvMMAX96712_96759_Constellation::GetCDIDeviceContext() {
    auto driverContext = new CNvMDevice::DriverContextImpl<ContextConstellation>();
    if (driverContext == nullptr) {
        return nullptr;
    }

    return std::unique_ptr<CNvMDevice::DriverContext>(driverContext);
}

SIPLStatus CNvMMAX96712_96759_Constellation::InitSimulatorAndSlave() {
    return NVSIPL_STATUS_OK;
}

CNvMCameraModule *CNvMCameraModule_Create() {
    return new CNvMMAX96712_96759_Constellation();
}

const char** CNvMCameraModule_GetNames() {
    static const char* names[] = {
        "Constellation",
        "Constellation_8M",
        NULL
    };
    return names;
}

} // end of namespace
