/* Copyright (c) 2018, NVIDIA CORPORATION.  All rights reserved.
 *
 * NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited.
 */

#ifndef _CMDLINE_H_
#define _CMDLINE_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <stdlib.h>

#include "nvmedia_core.h"
#include "log_utils.h"
#include "config_parser.h"
#include "img_dev.h"

#include "parser.h"

#define MAX_STRING_SIZE         256

typedef struct {
    NvMediaBool                 isUsed;
    union {
        uint32_t                   uIntValue;
        float                   floatValue;
        char                    stringValue[MAX_STRING_SIZE];
    };
} CmdlineParameter;

typedef struct {
    NvMediaBool                 positionSpecifiedFlag;
    NvMediaRect                 position;
    uint32_t                       logLevel;
    CmdlineParameter            inputFile;
    CmdlineParameter            outputFile;
    CmdlineParameter            paramFile;
    CmdlineParameter            configFile;
    CmdlineParameter            longPrint;
    CmdlineParameter            numSensors;
    CmdlineParameter            eepromAddress;
    CmdlineParameter            config;
    CmdlineParameter            operation;
    CaptureConfigParams        *captureConfigCollection;
    uint32_t                    captureConfigSetsNum;

} TestArgs;

NvMediaStatus
ParseArgs(int argc,
          char *argv[],
          TestArgs *allArgs);

void
PrintUsage(void);

#ifdef __cplusplus
}
#endif

#endif
