/*
 * Copyright (c) 2017-2020, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef _NVMEDIA_TEST_CMD_LINE_H_
#define _NVMEDIA_TEST_CMD_LINE_H_

#include "nvmedia_core.h"

typedef struct {
    char        *crcFilename;
    NvMediaBool crcGenMode;
    NvMediaBool crcCheckMode;
} CRCOptions;

typedef struct _TestArgs {
    unsigned int  width;
    unsigned int  height;
    char         *inputFilename;
    char         *outputFilename;
    char         *mvsFilename;
    NvMediaBool   mvsRefCheck;
    int           inputFormat;
    int           estimationType;
    int           numFrames;

    CRCOptions    crcoption;
    int           logLevel;
    int           enableExtHints;
    int           enableSegmentMap;
    char         *extHintsFileBaseName;
    int           bit_depth;
    int           chroma_format_idc;
    int           forward_ref;
    unsigned int  instanceId;
    unsigned int  enable_profiling;
    unsigned int  hintsPerMB;
    NvMediaBool   version;
    NvMediaBool   negTest;
    NvMediaBool   ipIsNull;
    NvMediaBool   refIsNull;
    NvMediaBool   opIsNull;
    char          *opCmpOrder;
    char          *opLayout;
    char          *layout;
    char          *memType;
    unsigned int  widthRef;
    unsigned int  heightRef;
    int           bit_depthRef;
    int           chroma_format_idcRef;
    char          *layoutRef;
    char          *memTypeRef;
    int           imagePoolSize;

    NvMediaBool   perfTest;
    double        avgTimePerFrame;

    NvMediaBool   negProcessHWID;
    NvMediaBool   negCreateHWID;
    NvMediaBool   negNVMEDIADevice;
    NvMediaBool   negMaxBuffering;
    NvMediaBool   negExtHint;
    NvMediaBool   negOutSurfType;
    NvMediaBool   negOutSurfDataType;
    NvMediaBool   negOutSurfBitDepth;
    NvMediaBool   negDestroy;
    NvMediaBool   negInitParam;
    NvMediaBool   negRegisterCheck;
    NvMediaBool   negProcessHandle;
    NvMediaBool   negProcessOSType;
    NvMediaBool   negIgnoreRegFailure;
} TestArgs;

//  PrintUsage
//
//    PrintUsage()  Prints video demo application usage options

void PrintUsage(void);

//  ParseArgs
//
//    ParseArgs()  Parsing command line arguments
//
//  Arguments:
//
//   argc
//      (in) Number of tokens in the command line
//
//   argv
//      (in) Command line tokens
//
//   args
//      (out) Pointer to test arguments structure

int  ParseArgs(int argc, char **argv, TestArgs *args);

#endif /* _NVMEDIA_TEST_CMD_LINE_H_ */
