/*
 * Copyright (c) 2017-2019, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef _ERROR_MAX96712_H_
#define _ERROR_MAX96712_H_

#include "nvmedia_isc.h"
#include "dev_error.h"
#include "isc_max96712.h"
#include "log_utils.h"

static inline NvMediaStatus
_GetError_max96712(
    NvMediaISCDevice *iscDeserializer,
    uint32_t *link,
    ExtImgDevFailureType *errorType)
{
    NvMediaStatus status = NVMEDIA_STATUS_OK;
    uint32_t i = 0u;
    ErrorStatusMAX96712 error = {};

    if(iscDeserializer == NULL || link == NULL) {
        return NVMEDIA_STATUS_BAD_PARAMETER;
    }

    /* Check error type here */
    status = MAX96712GetErrorStatus(iscDeserializer,
                                    sizeof(error),
                                    &error);
    if(status != NVMEDIA_STATUS_OK) {
        LOG_ERR("%s: MAX96712GetErrorStatus failed\n", __func__);
        return status;
    }

    *link = (uint32_t)error.link;

    for (i = 0u; i < MAX96712_MAX_NUM_LINK; i++) {
        switch(error.failureType[i]) {
            case ISC_MAX96712_GMSL1_LINK_UNLOCK :
                LOG_ERR("%s: GMSL1 Link %u Unlocked\n", __func__, i);
                break;
            case ISC_MAX96712_GMSL2_LINK_UNLOCK :
                LOG_ERR("%s: GMSL2 Link %u Unlocked\n", __func__, i);
                break;
            case ISC_MAX96712_GMSL1_DET_ERR :
                LOG_ERR("%s: GMSL1 Link %u decoding error(%d)\n", __func__, i, error.regVal[i]);
                break;
            case ISC_MAX96712_GMSL2_DEC_ERR :
                LOG_ERR("%s: GMSL2 Link %u decoding error(%d)\n", __func__, i, error.regVal[i]);
                break;
            case ISC_MAX96712_GMSL2_IDLE_ERR :
                LOG_ERR("%s: GMSL2 Link %u idle error(%d)\n", __func__, i, error.regVal[i]);
                break;
            case ISC_MAX96712_NO_ERROR:
                LOG_ERR("%s: No error detected\n", __func__);
                break;
            default:
                LOG_ERR("%s: Invalid link error type\n", __func__);
                return NVMEDIA_STATUS_ERROR;
        }
    }

    return NVMEDIA_STATUS_OK;
}

#endif /* _ERROR_MAX96712_H_ */
