/*
 * Copyright (c) 2019, NVIDIA CORPORATION.  All rights reserved.
 *
 * NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited.
 */

#ifndef _CAMERA_MODULE_EXPORT_HPP_
#define _CAMERA_MODULE_EXPORT_HPP_

#include "trace/CNvMTrace.hpp"
#include "CNvMCameraModule.hpp"

namespace nvsipl {

    // Return the driver implemented in the camera module driver library
    extern "C" CNvMCameraModule*
    CNvMCameraModule_Create();

    // Return a list of camera modules that should use this camera module driver library
    extern "C" const char**
    CNvMCameraModule_GetNames();

    // Get the version of the CNvMCameraModule API used by the library
    extern "C" const CNvMCameraModule::Version*
    CNvMCameraModule_GetVersion();

    // Set the debug level in the module driver library
    extern "C" void
    CNvMCameraModule_SetDebugLevel(
        CNvSIPLDeviceBlockTrace::TraceLevel level);

}

#endif /* _CAMERA_MODULE_EXPORT_HPP_ */