/*
 * Copyright (c) 2018, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef __CDI_CONSTELLATION_REGMAP_H__
#define __CDI_CONSTELLATION_REGMAP_H__

#include <stdbool.h>

#define REGMAP_ENTRY(regname, regaddr)          \
    [REG_## regname ##_CONSTELLATION] = {       \
        .name = #regname,                       \
        .addr = regaddr,                        \
        .data = 0,                              \
        .isSet = false                          \
    }

typedef struct DevBlkCDIRegSet {
    const char *name;
    const uint16_t addr;
    uint16_t data;
    bool isSet;
} DevBlkCDIRegSet;

/*--- enum for indexing regset ---*/
enum reg_index_constellation {
    REG_VERSION_CONSTELLATION = 0,
    REG_SUBVERSION_CONSTELLATION,
    REG_SENSOR_CONSTELLATION,
    REG_REVISION_CONSTELLATION,
    REG_MODULE_CONSTELLATION,
    REG_FRAME_COUNT_HIGH_CONSTELLATION,
    REG_FRAME_COUNT_LOW_CONSTELLATION,
    REG_WIDTH_CONSTELLATION,
    REG_HEIGHT_CONSTELLATION,
    REG_TOP_LINES_CONSTELLATION,
    REG_BOTTOM_LINES_CONSTELLATION,
    REG_OUTPUT_DEPTH_CONSTELLATION,
    REG_CFA_CONSTELLATION,
    CONSTELLATION_EMB_DATA_NUM_REGISTERS
};

/*--- register set ---*/
const DevBlkCDIRegSet regsel_constellation[] = {
    REGMAP_ENTRY(VERSION,               0x1000),
    REGMAP_ENTRY(SUBVERSION,            0x1002),
    REGMAP_ENTRY(SENSOR,                0x1004),
    REGMAP_ENTRY(REVISION,              0x1006),
    REGMAP_ENTRY(MODULE,                0x1008),
    REGMAP_ENTRY(FRAME_COUNT_HIGH,      0x100A),
    REGMAP_ENTRY(FRAME_COUNT_LOW,       0x100C),
    REGMAP_ENTRY(WIDTH,                 0x2000),
    REGMAP_ENTRY(HEIGHT,                0x2002),
    REGMAP_ENTRY(TOP_LINES,             0x2004),
    REGMAP_ENTRY(BOTTOM_LINES,          0x2006),
    REGMAP_ENTRY(OUTPUT_DEPTH,          0x2008),
    REGMAP_ENTRY(CFA,                   0x2010),
};


#endif /*__CDI_CONSTELLATION_REGMAP_H__*/
