/*
 * Copyright (c) 2019-2020, NVIDIA CORPORATION.  All rights reserved.
 *
 * NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited.
 */

#ifndef _CNVMMAX96712TPG_HPP_
#define _CNVMMAX96712TPG_HPP_

#include "ModuleIF/CNvMCameraModule.hpp"
#include "SensorIF/CNvMSensor.hpp"

namespace nvsipl
{

class CNvMMAX96712TPG : public CNvMCameraModule
{
public:
    SIPLStatus SetConfig(const CameraModuleConfig *cameraModuleConfig, const uint8_t linkIndex) override final;

    SIPLStatus Init() override final;

    SIPLStatus PostInit() override final;

    SIPLStatus Reconfigure() override final;

    SIPLStatus ReadEEPROMData(const std::uint16_t address,
                              const std::uint32_t length,
                              std::uint8_t * const buffer) override final;

#if !NV_IS_SAFETY
    SIPLStatus WriteEEPROMData(const std::uint16_t address,
                               const std::uint32_t length,
                               std::uint8_t * const buffer) override final;
#endif // !NV_IS_SAFETY

    SIPLStatus ToggleLED(bool enable) override;

    SIPLStatus Start() override final;

    SIPLStatus Stop() override final;

    SIPLStatus Deinit() override final;

    Property* GetCameraModuleProperty() override final;

    SIPLStatus CreateCDIDevice(DevBlkCDIRootDevice* cdiRoot) override final;

    uint16_t GetPowerOnDelayMs() override final;

    std::string GetSupportedDeserailizer() override final;

    CNvMDeserializer::LinkMode GetLinkMode() override final;
private:
    uint8_t m_initLinkMask;

    bool m_bSlave;

    CNvMDeserializer *m_pDeserializer;

    std::unique_ptr<CNvMSensor> m_upSensor;

    std::unique_ptr<Property> m_upCameraModuleProperty;

    std::string m_sModuleName;
};

} // end of namespace

#endif /* _CNVMMAX96712TPG_HPP_ */
