/*
 * Copyright (c) 2017-2020, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef _CDI_AR0144_H_
#define _CDI_AR0144_H_

#include "devblk_cdi.h"

#define SIZE_FUSE_ID                    16u
#define CDI_AR0144_AE_DISABLED          (1u << 0)
#define CDI_AR0144_AE_ENABLED           (1u << 1)

typedef enum {
    CDI_CONFIG_AR0144_DVP_RAW12_1280X800_60 = 0,
    CDI_CONFIG_AR0144_DVP_RAW12_1280X800_30,
    CDI_CONFIG_AR0144_ENABLE_STREAMING,
    CDI_CONFIG_AR0144_ENABLE_PG,
    CDI_CONFIG_AR0144_DISABLE_EMB_DATA,
} ConfigSetsAR0144;

typedef enum {
    CDI_READ_PARAM_CMD_AR0144_PCLK = 0,
} ReadParametersCmdAR0144;

typedef enum {
    CDI_AR0144_REV_4 = 0,
    CDI_AR0144_INVALID_REV,
} RevisionAR0144;

typedef struct {
    int32_t enumeratedDeviceConfig;
    uint32_t frameRate;
} ConfigInfoAR0144;

typedef struct {
    union {
        uint32_t pclk;
    };
} WriteReadParametersParamAR0144;

typedef struct {
    DevBlkCDIModuleConfig moduleConfig;
} ContextAR0144;

DevBlkCDIDeviceDriver *GetAR0144Driver(void);
NvMediaStatus GetAR0144ConfigSet(
    char *resolution,
    NvMediaICPInputFormatType inputFormat,
    int *configSet,
    uint32_t framerate);

NvMediaStatus
AR0144CheckPresence(
    DevBlkCDIDevice *handle);

NvMediaStatus
AR0144SetDefaults(
    DevBlkCDIDevice *handle);

NvMediaStatus
AR0144SetDeviceConfig(
    DevBlkCDIDevice *handle,
    uint32_t enumeratedDeviceConfig);

NvMediaStatus
AR0144ReadRegister(
    DevBlkCDIDevice *handle,
    uint32_t deviceIndex,
    uint32_t registerNum,
    uint32_t dataLength,
    uint8_t *dataBuff);

NvMediaStatus
AR0144WriteRegister(
    DevBlkCDIDevice *handle,
    uint32_t deviceIndex,
    uint32_t registerNum,
    uint32_t dataLength,
    uint8_t *dataBuff);

NvMediaStatus
AR0144ReadParameters(
    DevBlkCDIDevice *handle,
    uint32_t parameterType,
    uint32_t parameterSize,
    void *parameter);

NvMediaStatus
AR0144DumpRegisters(
    DevBlkCDIDevice *handle);

#endif /* _CDI_AR0144_H_ */
