/*
 * Copyright (c) 2018-2020, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef _CNVMMAX96712_HPP_
#define _CNVMMAX96712_HPP_

#include "DeserializerIF/CNvMDeserializer.hpp"
#include "utils/utils.hpp"

namespace nvsipl
{

extern "C" {
#include "cdi_max96712.h"
}

//! Class for Max96712 deserialzer
class CNvMMax96712 final: public CNvMDeserializer
{
public:
    ~CNvMMax96712();

    SIPLStatus SetConfig(const DeserInfo *deserInfo, DeserializerParams *params) override;

    SIPLStatus CreateCDIDevice(DevBlkCDIRootDevice* cdiRoot) override;

    SIPLStatus Init() override;

    SIPLStatus Deinit() override;

    SIPLStatus EnableLinks(uint8_t linkMask) override;

    SIPLStatus ControlLinks(const std::vector<LinkAction>& linkActions) override;

    SIPLStatus CheckLinkLock(uint8_t linkMask) override;

    SIPLStatus Start() override;

    SIPLStatus DetectErrors(std::uint8_t& cameraModules) override;

private:
    SIPLStatus SetMAX96712Ctx();

    //! Holds the revision of the MAX96712
    RevisionMAX96712 m_eRevision;
};

} // end of namespace nvsipl
#endif //_CNVMMAX96712_HPP_
