/*
 * Copyright (c) 2015-2018, NVIDIA CORPORATION. All rights reserved.
 *
 * NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited.
 */

#ifndef _GL_CONSUMER_H_
#define _GL_CONSUMER_H_
#include "egl_utils.h"
#include "eglstrm_setup.h"
#include <GLES2/gl2.h>
#include <GLES2/gl2ext.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

typedef struct {
    EGLStreamKHR              eglStream;
    EGLDisplay                eglDisplay;
    EglUtilState             *state;
    uint32_t                  width;
    uint32_t                  height;
    bool                      surfTypeIsRGBA;
    char                     *outputFrames;
    uint32_t                  frameCount;

    pthread_t                 procThread;
    GLboolean                 procThreadExited;
    volatile bool            *quit;
    volatile bool            *consumerDone;

} GLConsumerTestArgs;

NvMediaStatus glConsumerInit(volatile bool *consumerDone, GLConsumerTestArgs *ctx, EglStreamClient *streamClient,EglUtilState *state, InteropArgs *args);
void glConsumerFini(GLConsumerTestArgs *ctx);
void glConsumerStop(GLConsumerTestArgs *ctx);
void glConsumerFlush(GLConsumerTestArgs *ctx);

#endif
