/*
 * Copyright (c) 2018, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef _ISC_MAX96712_PG_SETTING_H_
#define _ISC_MAX96712_PG_SETTING_H_

static const uint8_t max96712_pg_settings[1000] = {
    /* 1920x1236, 30FPS */
    'w', 3, 0x00, 0x13, 0x75,
    'd',    0x27, 0x32,       /* Delay 10ms */
    'w', 3, 0x10, 0x51, 0x20,
    'd',    0x03, 0xE8,       /* Delay 1ms. FIx for Getframe timeouts on QNX. Bug 2189783*/
    'w', 3, 0x10, 0x52, 0x00, /* VS_DLY  */
    'w', 3, 0x10, 0x53, 0x00,
    'w', 3, 0x10, 0x54, 0x00,
    'w', 3, 0x10, 0x55, 0x00, /* VS_HIGH */
    'w', 3, 0x10, 0x56, 0x3D,
    'w', 3, 0x10, 0x57, 0x68,
    'w', 3, 0x10, 0x58, 0x4B, /* VS_LOW */
    'w', 3, 0x10, 0x59, 0x9B,
    'w', 3, 0x10, 0x5A, 0x40,
    'w', 3, 0x10, 0x5B, 0x09, /* V2H */
    'w', 3, 0x10, 0x5C, 0xD3,
    'w', 3, 0x10, 0x5D, 0x50,
    'w', 3, 0x10, 0x5E, 0x0C, /* HS_HIGH */
    'w', 3, 0x10, 0x5F, 0x1C,
    'w', 3, 0x10, 0x60, 0x00, /* HS_LOW */
    'w', 3, 0x10, 0x61, 0x2C,
    'w', 3, 0x10, 0x62, 0x06, /* HS_CNT */
    'w', 3, 0x10, 0x63, 0x2D,
    'w', 3, 0x10, 0x64, 0x09, /* V2D */
    'w', 3, 0x10, 0x65, 0xD5,
    'w', 3, 0x10, 0x66, 0xA8,
    'w', 3, 0x10, 0x67, 0x07, /* DE_HIGH */
    'w', 3, 0x10, 0x68, 0x80,
    'w', 3, 0x10, 0x69, 0x04, /* DE_LOW */
    'w', 3, 0x10, 0x6A, 0xD8,
    'w', 3, 0x10, 0x6B, 0x04, /* DE_CNT */
    'w', 3, 0x10, 0x6C, 0xD4,
    'w', 3, 0x10, 0x6D, 0x03,
    'w', 3, 0x10, 0x6E, 0x80,
    'w', 3, 0x10, 0x6F, 0x00,
    'w', 3, 0x10, 0x70, 0x04,
    'w', 3, 0x10, 0x71, 0x00,
    'w', 3, 0x10, 0x72, 0x08,
    'w', 3, 0x10, 0x73, 0x80,
    'w', 3, 0x10, 0x74, 0x50,
    'w', 3, 0x10, 0x75, 0xA0,
    'w', 3, 0x10, 0x76, 0x50,
    'w', 3, 0x01, 0xDD, 0x1B,
    'w', 3, 0x01, 0xFD, 0x1B,
    'w', 3, 0x02, 0x1D, 0x1B,
    'w', 3, 0x02, 0x3D, 0x1B,
    'w', 3, 0x08, 0xA0, 0x80, /* Forced MIPI clock */
    'w', 3, 0x08, 0xA2, 0xF0,
    'w', 3, 0x00, 0x06, 0x00, /* disable all links */
    'w', 3, 0x00, 0x18, 0x0F,
    'e'
};

static const uint8_t max96712_enable_pg[6] = {
    'w', 3, 0x10, 0x50, 0xF3,
    'e'
};

#endif /* _ISC_MAX96712_PG_SETTING_H_ */
