/* Copyright (c) 2019-2020, NVIDIA CORPORATION.  All rights reserved.
 *
 * NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited.
 */

#ifndef _CNVMMAX96712_96759_CONSTELLATION_HPP_
#define _CNVMMAX96712_96759_CONSTELLATION_HPP_

#include "cameramodule/MAX96712cameramodule/CNvMMAX96712_96759CameraModule.hpp"

namespace nvsipl
{

class CNvMMAX96712_96759_Constellation : public CNvMMAX96712_96759CameraModule
{
protected:
    SIPLStatus SetConfigModule(const SensorInfo *sensorInfo, CNvMDevice::DeviceParams *params) override;

    SIPLStatus DetectModule() override;

    SIPLStatus InitModule() override;

    SIPLStatus StartModule() override;

    SIPLStatus StopModule() override;

    SIPLStatus DeinitModule() override;

    DevBlkCDIDeviceDriver *GetCDIDeviceDriver() override;

    std::unique_ptr<CNvMDevice::DriverContext> GetCDIDeviceContext() override;

    int m_ConfigIndex;

private:
    SIPLStatus InitSimulatorAndSlave();
};

} // end of namespace

#endif /* _CNVMMAX96712_96759_CONSTELLATION_HPP_ */
