/*
 * Copyright (c) 2019, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#include "testRuntime.h"
#include "testSciSync.h"
#include "cmdParser.h"
#include "utils.h"
#include <chrono>
#include <thread>

int main(int argc, char *argv[])
{
    CmdParser cmdline {};
    NvMediaStatus status = NVMEDIA_STATUS_OK;

    int ret = 0;
    ret = cmdline.Parse(argc, argv);
    if (ret != 0) {
        CmdParser::ShowUsage();
        return ret;
    }

    LOG_INFO(">>>>>>>>>>>>>>>>>>>> Test Begin >>>>>>>>>>>>>>>>>>>> \n");
    LOG_INFO("List of input arguments: \n");
    cmdline.PrintArgs();

    if (cmdline.testRuntime || cmdline.testPing) {
        LOG_INFO("Runtime test with dlaId = %d numTasks = %d profile name %s PingTest %d\n",\
                  cmdline.dlaId, cmdline.numTasks, cmdline.loadableName.c_str(), cmdline.testPing);

        // Runtime test
        TestRuntime test(cmdline.dlaId, cmdline.numTasks, cmdline.loadableName, cmdline.testPing);
        status = test.SetUp();
        if (status != NVMEDIA_STATUS_OK) {
            LOG_ERR("Test setup fails \n");
            ret = -1;
            goto fail;
        }
        status = test.RunTest();
        if (status != NVMEDIA_STATUS_OK) {
            LOG_ERR("Test setup fails \n");
            ret = -1;
            goto fail;
        }
    } else if (cmdline.testSciSync) {
        LOG_INFO("Scisync test with dlaId = %d numTasks = %d profile name %s PingTest %d\n",\
                  cmdline.dlaId, cmdline.numTasks, cmdline.loadableName.c_str(), cmdline.testPing);

        // SciSync Test
        TestSciSync test(cmdline.dlaId, cmdline.numTasks, cmdline.loadableName);
        status = test.SetUp();
        if (status != NVMEDIA_STATUS_OK) {
            LOG_ERR("Test setup fails \n");
            ret = -1;
            goto fail;
        }

        status = test.RunTest();
        if (status != NVMEDIA_STATUS_OK) {
            LOG_ERR("Test setup fails \n");
            ret = -1;
            goto fail;
        }
    }

fail:
    if (ret != 0) {
        LOG_INFO(">>>>>>>>>>>>>>>>>>>> Test Fail >>>>>>>>>>>>>>>>>>>> \n");
    } else {
        LOG_INFO(">>>>>>>>>>>>>>>>>>>> Test Pass >>>>>>>>>>>>>>>>>>>> \n");
    }

    LOG_INFO("<<<<<<<<<<<<<<<<<<<< Test End <<<<<<<<<<<<<<<<<<<<< \n");
    return ret;

}
