/*
 * Copyright (c) 2016-2018, NVIDIA CORPORATION. All rights reserved.
 *
 * NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited.
 */

#ifndef _CMDLINE_H_
#define _CMDLINE_H_

#include <stdbool.h>

#include "nvmedia_core.h"
#include "nvmedia_surface.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define FILE_PATH_LENGTH_MAX    256

typedef enum
{
    EGLSTREAM_NVMEDIA_VIDEO = 0,
    EGLSTREAM_NVMEDIA_IMAGE = 1,
    EGLSTREAM_GL            = 2,
    EGLSTREAM_CUDA          = 3,

} ProdConsType;

typedef enum
{
    IMAGE_TYPE_YUV420 = 0,
    IMAGE_TYPE_RGBA = 1,
    IMAGE_TYPE_RAW = 2,
}ImageType;

typedef struct _TestArgs {

    uint32_t       width;
    uint32_t       height;
    uint32_t       frameCount;
    ImageType      imagetype;
    ProdConsType   producer;
    ProdConsType   consumer;
    char           *inpFileName;
    char           *outFileName;
    int            logLevel;
    bool           fifoMode;

    /*Cross proc*/
    bool           isCrossProc;
    bool           isProdCrossProc;
    bool           isConsCrossProc;

    bool           pitchLinearOutput;
    bool           isConsumerondGPU;
    bool           useblitpath;
} TestArgs;

void PrintUsage(void);
int MainParseArgs(int argc, char **argv, TestArgs *args);

#endif
