/* Copyright (c) 2018, NVIDIA CORPORATION.  All rights reserved.
 *
 * NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited.
 */

#ifndef __CMD_LINE_H__
#define __CMD_LINE_H__

#include "nvmedia_core.h"
#include "nvmedia_surface.h"
#include "nvmedia_image.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
    // Input image
    char                        *inputFileName1;
    char                        *inputFileName2;
    uint32_t                    inputSurfType;
    uint32_t                    inputWidth;
    uint32_t                    inputHeight;

    // Output image
    char                        *outputFileName;
    uint32_t                    outputSurfType;
    uint32_t                    outputWidth;
    uint32_t                    outputHeight;

    uint32_t                    numFrames;
    uint32_t                    loop;
    uint32_t                    logLevel;

} TestArgs;

int
ParseArgs (
    int argc,
    char *argv[],
    TestArgs *testArgs);

void
PrintUsage (void);

#ifdef __cplusplus
}
#endif

#endif
