/*
 * Copyright (c) 2018-2020 NVIDIA Corporation.  All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property
 * and proprietary rights in and to this software and related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA Corporation is strictly prohibited.
 */


#ifndef __CDI_AR0144_REGMAP_H__
#define __CDI_AR0144_REGMAP_H__

#define REG_DATA_FORMAT_BITS  0x31AC
#define REG_CHIP_ID           0x3000
#define REG_STAT_FRAME_ID     0x31D2
#define REG_FIT               0x3014
#define REG_GROUP_HOLD        0x3022
#define REG_INTEG_TIME_T1     0x3012
#define REG_AGAIN             0x3060
#define REG_DGAIN             0x305E
#define REG_DGAIN_GR          0x3056
#define REG_TEMPSENS0_DATA    0x30B2
#define REG_TEMPSENS0_CTL     0x30B4
#define REG_FRAME_COUNT       0x303A
#define REG_DEV_REV_ADDR      0x300E
#define REG_DATA_FORMAT       0x31AC
#define REG_AECTRLREG         0x3100
#define REG_PLL_VT_PIXDIV     0x302A
#define REG_FRAME_REPORT      0x31D2

#define SEL_EMB_LENGTH_AR0144 (59)

typedef struct {
    char* name;
    uint16_t addr;
    uint16_t data;
} CDIRegSetAR0144;

/*--- enum for indexing regset ---*/
enum reg_index_ar0144 {
    REG_CHIP_VERSION_REG_AR0144,
    REG_Y_ADDR_START_AR0144,
    REG_X_ADDR_START_AR0144,
    REG_Y_ADDR_END_AR0144,
    REG_X_ADDR_END_AR0144,
    REG_FRAME_LENGTH_LINES_AR0144,
    REG_LINE_LENGTH_PCK_AR0144,
    REG_COARSE_INTEGRATION_TIME_AR0144,
    REG_FINE_INTEGRATION_TIME_AR0144,
    REG_DATA_PEDESTAL_AR0144,
    REG_VT_PIX_CLK_DIV_AR0144,
    REG_VT_SYS_CLK_DIV_AR0144,
    REG_PRE_PLL_CLK_DIV_AR0144,
    REG_PLL_MULTIPLIER_AR0144,
    REG_OP_PIX_CLK_DIV_AR0144,
    REG_OP_SYS_CLK_DIV_AR0144,
    REG_GREEN1_GAIN_AR0144,
    REG_BLUE_GAIN_AR0144,
    REG_RED_GAIN_AR0144,
    REG_GREEN2_GAIN_AR0144,
    REG_GLOBAL_GAIN_AR0144,
    REG_ANALOG_GAIN_AR0144,
    REG_AECTRLREG_AR0144,
    REG_AE_LUMA_TARGET_REG_AR0144,
    REG_AE_MIN_EV_STEP_REG_AR0144,
    REG_AE_MAX_EV_STEP_REG_AR0144,
    REG_AE_DAMP_OFFSET_REG_AR0144,
    REG_AE_DAMP_GAIN_REG_AR0144,
    REG_AE_DAMP_MAX_REG_AR0144,
    REG_AE_MAX_EXPOSURE_REG_AR0144,
    REG_AE_MIN_EXPOSURE_REG_AR0144,
    REG_AE_DARK_CUR_THRESH_REG_AR0144,
    REG_AE_CURRENT_GAINS_AR0144,
    REG_AE_ROI_X_START_OFFSET_AR0144,
    REG_AE_ROI_Y_START_OFFSET_AR0144,
    REG_AE_ROI_X_SIZE_AR0144,
    REG_AE_ROI_Y_SIZE_AR0144,
    REG_AE_HIST_BEGIN_PERC_AR0144,
    REG_AE_HIST_END_PERC_AR0144,
    REG_AE_HIST_DIV_AR0144,
    REG_AE_NORM_WIDTH_MIN_AR0144,
    REG_AE_MEAN_H_AR0144,
    REG_AE_MEAN_L_AR0144,
    REG_AE_HIST_BEGIN_H_AR0144,
    REG_AE_HIST_BEGIN_L_AR0144,
    REG_AE_HIST_END_H_AR0144,
    REG_AE_HIST_END_L_AR0144,
    REG_AE_LOW_END_MEAN_H_AR0144,
    REG_AE_LOW_END_MEAN_L_AR0144,
    REG_AE_PERC_LOW_END_AR0144,
    REG_AE_NORM_ABS_DEV_AR0144,
    REG_AE_COARSE_INTEGRATION_TIME_AR0144,
    REG_AE_AG_EXPOSURE_HI_AR0144,
    REG_AE_AG_EXPOSURE_LO_AR0144,
    REG_TEMPSENS_DATA_REG_AR0144,
    REG_TEMPSENS_CALIB1_AR0144,
    REG_TEMPSENS_CTRL_REG_AR0144,
    REG_FRAME_COUNT_AR0144,
    REG_FRAME_REPORT_AR0144,
};

const CDIRegSetAR0144 regsel_ar0144[SEL_EMB_LENGTH_AR0144] = {
    {.name = "CHIP_VERSION_REG", .addr = 0X3000, .data = 0},
    {.name = "Y_ADDR_START", .addr = 0X3002, .data = 0},
    {.name = "X_ADDR_START", .addr = 0X3004, .data = 0},
    {.name = "Y_ADDR_END", .addr = 0X3006, .data = 0},
    {.name = "X_ADDR_END", .addr = 0X3008, .data = 0},
    {.name = "FRAME_LENGTH_LINES", .addr = 0X300A, .data = 0},
    {.name = "LINE_LENGTH_PCK", .addr = 0X300C, .data = 0},
    {.name = "COARSE_INTEGRATION_TIME", .addr = 0X3012, .data = 0},
    {.name = "FINE_INTEGRATION_TIME", .addr = 0X3014, .data = 0},
    {.name = "DATA_PEDESTAL", .addr = 0X301E, .data = 0},
    {.name = "VT_PIX_CLK_DIV", .addr = 0X302A, .data = 0},
    {.name = "VT_SYS_CLK_DIV", .addr = 0X302C, .data = 0},
    {.name = "PRE_PLL_CLK_DIV", .addr = 0X302E, .data = 0},
    {.name = "PLL_MULTIPLIER", .addr = 0X3030, .data = 0},
    {.name = "OP_PIX_CLK_DIV", .addr = 0X3036, .data = 0},
    {.name = "OP_SYS_CLK_DIV", .addr = 0X3038, .data = 0},
    {.name = "GREEN1_GAIN", .addr = 0X3056, .data = 0},
    {.name = "BLUE_GAIN", .addr = 0X3058, .data = 0},
    {.name = "RED_GAIN", .addr = 0X305A, .data = 0},
    {.name = "GREEN2_GAIN", .addr = 0X305C, .data = 0},
    {.name = "GLOBAL_GAIN", .addr = 0X305E, .data = 0},
    {.name = "ANALOG_GAIN", .addr = 0X3060, .data = 0},
    {.name = "AECTRLREG", .addr = 0X3100, .data = 0},
    {.name = "AE_LUMA_TARGET_REG", .addr = 0X3102, .data = 0},
    {.name = "AE_MIN_EV_STEP_REG", .addr = 0X3108, .data = 0},
    {.name = "AE_MAX_EV_STEP_REG", .addr = 0X310A, .data = 0},
    {.name = "AE_DAMP_OFFSET_REG", .addr = 0X310C, .data = 0},
    {.name = "AE_DAMP_GAIN_REG", .addr = 0X310E, .data = 0},
    {.name = "AE_DAMP_MAX_REG", .addr = 0X3110, .data = 0},
    {.name = "AE_MAX_EXPOSURE_REG", .addr = 0X311C, .data = 0},
    {.name = "AE_MIN_EXPOSURE_REG", .addr = 0X311E, .data = 0},
    {.name = "AE_DARK_CUR_THRESH_REG", .addr = 0X3124, .data = 0},
    {.name = "AE_CURRENT_GAINS", .addr = 0X312A, .data = 0},
    {.name = "AE_ROI_X_START_OFFSET", .addr = 0X3140, .data = 0},
    {.name = "AE_ROI_Y_START_OFFSET", .addr = 0X3142, .data = 0},
    {.name = "AE_ROI_X_SIZE", .addr = 0X3144, .data = 0},
    {.name = "AE_ROI_Y_SIZE", .addr = 0X3146, .data = 0},
    {.name = "AE_HIST_BEGIN_PERC", .addr = 0X3148, .data = 0},
    {.name = "AE_HIST_END_PERC", .addr = 0X314A, .data = 0},
    {.name = "AE_HIST_DIV", .addr = 0X314C, .data = 0},
    {.name = "AE_NORM_WIDTH_MIN", .addr = 0X314E, .data = 0},
    {.name = "AE_MEAN_H", .addr = 0X3150, .data = 0},
    {.name = "AE_MEAN_L", .addr = 0X3152, .data = 0},
    {.name = "AE_HIST_BEGIN_H", .addr = 0X3154, .data = 0},
    {.name = "AE_HIST_BEGIN_L", .addr = 0X3156, .data = 0},
    {.name = "AE_HIST_END_H", .addr = 0X3158, .data = 0},
    {.name = "AE_HIST_END_L", .addr = 0X315A, .data = 0},
    {.name = "AE_LOW_END_MEAN_H", .addr = 0X315C, .data = 0},
    {.name = "AE_LOW_END_MEAN_L", .addr = 0X315E, .data = 0},
    {.name = "AE_PERC_LOW_END", .addr = 0X3160, .data = 0},
    {.name = "AE_NORM_ABS_DEV", .addr = 0X3162, .data = 0},
    {.name = "AE_COARSE_INTEGRATION_TIME", .addr = 0X3164, .data = 0},
    {.name = "AE_AG_EXPOSURE_HI", .addr = 0X3166, .data = 0},
    {.name = "AE_AG_EXPOSURE_LO", .addr = 0X3168, .data = 0},
    {.name = "TEMPSENS_DATA_REG", .addr = 0X30B2, .data = 0},
    {.name = "TEMPSENS_CALIB1", .addr = 0X30C6, .data = 0},
    {.name = "TEMPSENS_CTRL_REG", .addr = 0X30B4, .data = 0},
    {.name = "FRAME_COUNT", .addr = 0X303A, .data = 0},
    {.name = "FRAME_REPORT", .addr = 0X31D2, .data = 0},
};

#endif /*__CDI_AR0144_REGMAP_H__*/


