/*
 * Copyright (c) 2016-2019, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef _NVMEDIA_IMAGEPLAY_CMD_LINE_H_
#define _NVMEDIA_IMAGEPLAY_CMD_LINE_H_

#include <stdbool.h>

#include "nvmedia_core.h"
#include "nvmedia_surface.h"
#include "nvmedia_parser.h"

typedef struct _TestArgs {
    int                      logLevel;
    NvMediaVideoCodec        eCodec;
    char                    *filename;
    int64_t                  fileSize;
    char                    *OutputYUVFilename;
    int                      loop;
    float                    aspectRatio;
    double                   frameTimeUSec;
    int                      numFramesToDecode;
    int                      displayId;
    bool                     displayEnabled;
    bool                     positionSpecifiedFlag;
    bool                     showDecodeTimimg;
    NvMediaRect              position;
    unsigned int             windowId;
    unsigned int             depth;
    unsigned int             instanceId;
    NvMediaBool              checkCRC;
    NvMediaBool              generateCRC;
    NvMediaBool              cropCRC;
    char                    *crcFilePath;
    NvMediaBool              decProfiling;
} TestArgs;

//  PrintUsage
//
//    PrintUsage()  Prints video demo application usage options

void PrintUsage(void);

//  ParseArgs
//
//    ParseArgs()  Parsing command line arguments
//
//  Arguments:
//
//   argc
//      (in) Number of tokens in the command line
//
//   argv
//      (in) Command line tokens
//
//   args
//      (out) Pointer to test arguments structure

int  ParseArgs(int argc, char **argv, TestArgs *args);

#endif /* _NVMEDIA_IMAGEPLAY_CMD_LINE_H_ */
