/*
 * Copyright (c) 2019, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef _NVMEDIA_2D_CMD_LINE_H_
#define _NVMEDIA_2D_CMD_LINE_H_

/* Include header containing NvMedia2D declarations */
#include "nvmedia_2d.h"

/* Maximum length of the path including file name */
#define FILE_NAME_SIZE 1024

/* TestArgs contains all arguments required to run the 2D test */
typedef struct _TestArgs {
    int logLevel;
    char inputFileName[FILE_NAME_SIZE];
    char outputFileName[FILE_NAME_SIZE];

    uint32_t crcMode;
    char CRCFileName[FILE_NAME_SIZE];

    NvMediaSurfAllocAttr srcSurfAllocAttrs[NVM_SURF_ALLOC_ATTR_MAX];
    NvMediaSurfAllocAttr dstSurfAllocAttrs[NVM_SURF_ALLOC_ATTR_MAX];
    uint32_t numSurfAllocAttrs;

    NvMediaSurfFormatAttr srcSurfFormatAttrs[NVM_SURF_FMT_ATTR_MAX];
    NvMediaSurfFormatAttr dstSurfFormatAttrs[NVM_SURF_FMT_ATTR_MAX];

    NvMediaRect srcRect;
    NvMediaRect dstRect;
    NvMedia2DBlitParameters     blitParams;
} TestArgs;

typedef struct {
    NvMediaDevice               *device;
    /* I2D for 2D blit processing */
    NvMedia2D                   *i2d;
    NvMediaImage                *srcImage;
    NvMediaImage                *dstImage;
    NvMediaRect                 *srcRect;
    NvMediaRect                 *dstRect;
} Blit2DTest;

/* Prints application usage options */
void PrintUsage (void);

/* Parses command line arguments.
* Also parses any configuration files supplied in the command line arguments.
* Arguments:
* argc
*    (in) Number of tokens in the command line
* argv
*    (in) Command line tokens
* args
*    (out) Pointer to test arguments structure
*/
int  ParseArgs(int argc, char **argv, TestArgs *args);

#endif /* _NVMEDIA_2D_CMD_LINE_H_ */
