/*
 * Copyright (c) 2017-2019, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef _ISC_N24C64_H_
#define _ISC_N24C64_H_

#include "nvmedia_isc.h"

NvMediaISCDeviceDriver*
GetN24C64Driver(
    void);

NvMediaStatus
N24C64CheckPresence(
    NvMediaISCDevice *handle);

NvMediaStatus
N24C64ReadRegister(
    NvMediaISCDevice *handle,
    uint32_t deviceIndex,
    uint32_t registerNum,
    uint32_t dataLength,
    uint8_t *dataBuff);

NvMediaStatus
N24C64WriteRegister(
    NvMediaISCDevice *handle,
    uint32_t deviceIndex,
    uint32_t registerNum,
    uint32_t dataLength,
    uint8_t *dataBuff);

#endif /* _ISC_N24C64_H_ */
