/*
 * Copyright (c) 2019 NVIDIA Corporation.  All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property
 * and proprietary rights in and to this software and related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA Corporation is strictly prohibited.
 */


#ifndef __ISC_AR0231_REGMAP_H__
#define __ISC_AR0231_REGMAP_H__

#define REG_DATA_FORMAT_BITS  0x31AC
#define REG_CHIP_ID           0x3000
#define REG_FRAME_REPORT      0x31D2
#define REG_STAT_FRAME_ID     0x31D2
#define REG_FIT1              0x3014
#define REG_EMB_CTL           0x3064
#define REG_FIT2              0x321E
#define REG_FIT3              0x3222
#define REG_GROUP_HOLD        0x3022
#define REG_INTEG_TIME_T1     0x3012
#define REG_INTEG_TIME_T2     0x3212
#define REG_CGAIN             0x3362
#define REG_AGAIN             0x3366
#define REG_DGAIN             0x3308
#define REG_TEMPSENS1_DATA    0x20B2
#define REG_TEMPSENS1_CTL     0x30B8
#define REG_TEMPSENS0_CAL1    0x30C6
#define REG_TEMPSENS0_CAL2    0x30C8
#define REG_TEMPSENS1_CAL1    0x30CA
#define REG_TEMPSENS1_CAL2    0x30CC
#define REG_DGAIN_GR          0x3056
#define REG_FUSE_ID           0x34C0
#define REG_TEMPSENS0_DATA    0x20B0
#define REG_TEMPSENS0_CTL     0x30B4
#define REG_DLO_CTL           0x318E
#define REG_DATA_FORMAT       0x31AC
#define REG_HDR_CTL           0x3110
#define REG_FRAME_COUNT_MSB   0x2000
#define REG_FRAME_COUNT_LSB   0x2002
#define REG_DEV_REV_ADDR      0x31FE

#define SEL_EMB_LENGTH_AR0231 (84)

typedef struct {
    char* name;
    uint16_t addr;
    uint16_t data;
} ISCRegSetAR0231;

/*--- enum for indexing regset ---*/
enum reg_index_AR0231 {
    REG_EXPOSURE_T1_ROW_AR0231,
    REG_EXPOSURE_T2_ROW_AR0231,
    REG_EXPOSURE_T3_ROW_AR0231,
    REG_EXPOSURE_T4_ROW_AR0231,
    REG_EXPOSURE_T1_CLK_U_AR0231,
    REG_EXPOSURE_T1_CLK_L_AR0231,
    REG_EXPOSURE_T2_CLK_U_AR0231,
    REG_EXPOSURE_T2_CLK_L_AR0231,
    REG_EXPOSURE_T3_CLK_U_AR0231,
    REG_EXPOSURE_T3_CLK_L_AR0231,
    REG_EXPOSURE_T4_CLK_U_AR0231,
    REG_EXPOSURE_T4_CLK_L_AR0231,
    REG_FINE_INTEGRATION_ACTUAL_T1_AR0231,
    REG_FINE_INTEGRATION_ACTUAL_T2_AR0231,
    REG_FINE_INTEGRATION_ACTUAL_T3_AR0231,
    REG_FINE_INTEGRATION_ACTUAL_T4_AR0231,
    REG_RATIO_ACTUAL_T1_T2_AR0231,
    REG_RATIO_ACTUAL_T2_T3_AR0231,
    REG_RATIO_ACTUAL_T3_T4_AR0231,
    REG_RATIO_ACTUAL_T2_T1_AR0231,
    REG_RATIO_ACTUAL_T1_T3_MSB_AR0231,
    REG_RATIO_ACTUAL_T1_T3_AR0231,
    REG_RATIO_ACTUAL_T1_T4_MSB_AR0231,
    REG_RATIO_ACTUAL_T1_T4_AR0231,
    REG_FINE_INT_ERR_AR0231,
    REG_TEMPSENS0_DATA_REG_AR0231,
    REG_TEMPSENS1_DATA_REG_AR0231,
    REG_CHIP_VERSION_REG_AR0231,
    REG_FRAME_LENGTH_LINES__AR0231,
    REG_LINE_LENGTH_PCK__AR0231,
    REG_COARSE_INTEGRATION_TIME__AR0231,
    REG_FINE_INTEGRATION_TIME__AR0231,
    REG_DATA_PEDESTAL__AR0231,
    REG_VT_PIX_CLK_DIV_AR0231,
    REG_VT_SYS_CLK_DIV_AR0231,
    REG_PLL_MULTIPLIER_AR0231,
    REG_OP_WORD_CLK_DIV_AR0231,
    REG_OP_SYS_CLK_DIV_AR0231,
    REG_GREEN1_GAIN_AR0231,
    REG_BLUE_GAIN_AR0231,
    REG_RED_GAIN_AR0231,
    REG_GREEN2_GAIN_AR0231,
    REG_GLOBAL_GAIN_AR0231,
    REG_ANALOG_COLOR_GAIN_T1_AR0231,
    REG_ROW_NOISE_CONTROL_AR0231,
    REG_NOISE_PEDESTAL_AR0231,
    REG_DLO_CONTROL0_AR0231,
    REG_DLO_CONTROL1_AR0231,
    REG_DLO_CONTROL2_AR0231,
    REG_DLO_CONTROL3_AR0231,
    REG_DLO_CONTROL4_AR0231,
    REG_HDR_CONTROL0_AR0231,
    REG_HDR_SC_CONTROL0_AR0231,
    REG_HDR_SC_CONTROL1_AR0231,
    REG_HDR_MD_CONTROL0_AR0231,
    REG_HDR_MD_CONTROL1_AR0231,
    REG_HDR_SF_CONTROL0_AR0231,
    REG_CUSTOMER_REV_AR0231,
    REG_COARSE_INTEGRATION_TIME2_AR0231,
    REG_COARSE_INTEGRATION_TIME3_AR0231,
    REG_COARSE_INTEGRATION_TIME4_AR0231,
    REG_FINE_INTEGRATION_TIME2_AR0231,
    REG_FINE_INTEGRATION_TIME3_AR0231,
    REG_FINE_INTEGRATION_TIME4_AR0231,
    REG_FINE_CORRECTION_AR0231,
    REG_FINE_CORRECTION2_AR0231,
    REG_FINE_CORRECTION3_AR0231,
    REG_FINE_CORRECTION4_AR0231,
    REG_EXPOSURE_RATIO_AR0231,
    REG_DC_GAIN_AR0231,
    REG_ANALOG_GAIN_AR0231,
    REG_DIGITAL_GAIN_AR0231,
    REG_DBLC_PEDESTAL_AR0231,
    REG_TPG_COLOR0_GR1_HI_AR0231,
    REG_TPG_COLOR1_GR1_HI_AR0231,
    REG_FRAME_COUNT_MSB_AR0231,
    REG_FRAME_COUNT_LSB_AR0231,
    REG_FRAME_REPORT_AR0231,
    REG_TEMPSENS0_CTL_REG_AR0231,
    REG_TEMPSENS1_CTL_REG_AR0231,
    REG_TEMPSENS0_CAL1_REG_AR0231,
    REG_TEMPSENS0_CAL2_REG_AR0231,
    REG_TEMPSENS1_CAL1_REG_AR0231,
    REG_TEMPSENS1_CAL2_REG_AR0231,
};

const ISCRegSetAR0231 regsel_AR0231[SEL_EMB_LENGTH_AR0231] = {
    {.name = "EXPOSURE_T1_ROW", .addr = 0X2020, .data = 0},
    {.name = "EXPOSURE_T2_ROW", .addr = 0X2022, .data = 0},
    {.name = "EXPOSURE_T3_ROW", .addr = 0X2024, .data = 0},
    {.name = "EXPOSURE_T4_ROW", .addr = 0X2026, .data = 0},
    {.name = "EXPOSURE_T1_CLK_U", .addr = 0X2028, .data = 0},
    {.name = "EXPOSURE_T1_CLK_L", .addr = 0X202A, .data = 0},
    {.name = "EXPOSURE_T2_CLK_U", .addr = 0X202C, .data = 0},
    {.name = "EXPOSURE_T2_CLK_L", .addr = 0X202E, .data = 0},
    {.name = "EXPOSURE_T3_CLK_U", .addr = 0X2030, .data = 0},
    {.name = "EXPOSURE_T3_CLK_L", .addr = 0X2032, .data = 0},
    {.name = "EXPOSURE_T4_CLK_U", .addr = 0X2034, .data = 0},
    {.name = "EXPOSURE_T4_CLK_L", .addr = 0X2036, .data = 0},
    {.name = "FINE_INTEGRATION_ACTUAL_T1", .addr = 0X2038, .data = 0},
    {.name = "FINE_INTEGRATION_ACTUAL_T2", .addr = 0X203A, .data = 0},
    {.name = "FINE_INTEGRATION_ACTUAL_T3", .addr = 0X203C, .data = 0},
    {.name = "FINE_INTEGRATION_ACTUAL_T4", .addr = 0X203E, .data = 0},
    {.name = "RATIO_ACTUAL_T1_T2", .addr = 0X2040, .data = 0},
    {.name = "RATIO_ACTUAL_T2_T3", .addr = 0X2042, .data = 0},
    {.name = "RATIO_ACTUAL_T3_T4", .addr = 0X2044, .data = 0},
    {.name = "RATIO_ACTUAL_T2_T1", .addr = 0X2046, .data = 0},
    {.name = "RATIO_ACTUAL_T1_T3_MSB", .addr = 0X2048, .data = 0},
    {.name = "RATIO_ACTUAL_T1_T3", .addr = 0X204A, .data = 0},
    {.name = "RATIO_ACTUAL_T1_T4_MSB", .addr = 0X204C, .data = 0},
    {.name = "RATIO_ACTUAL_T1_T4", .addr = 0X204E, .data = 0},
    {.name = "FINE_INT_ERR", .addr = 0X2074, .data = 0},
    {.name = "TEMPSENS0_DATA_REG", .addr = 0X20B0, .data = 0},
    {.name = "TEMPSENS1_DATA_REG", .addr = 0X20B2, .data = 0},
    {.name = "CHIP_VERSION_REG", .addr = 0X3000, .data = 0},
    {.name = "FRAME_LENGTH_LINES_", .addr = 0X300A, .data = 0},
    {.name = "LINE_LENGTH_PCK_", .addr = 0X300C, .data = 0},
    {.name = "COARSE_INTEGRATION_TIME_", .addr = 0X3012, .data = 0},
    {.name = "FINE_INTEGRATION_TIME_", .addr = 0X3014, .data = 0},
    {.name = "DATA_PEDESTAL_", .addr = 0X301E, .data = 0},
    {.name = "VT_PIX_CLK_DIV", .addr = 0X302A, .data = 0},
    {.name = "VT_SYS_CLK_DIV", .addr = 0X302C, .data = 0},
    {.name = "PLL_MULTIPLIER", .addr = 0X3030, .data = 0},
    {.name = "OP_WORD_CLK_DIV", .addr = 0X3036, .data = 0},
    {.name = "OP_SYS_CLK_DIV", .addr = 0X3038, .data = 0},
    {.name = "GREEN1_GAIN", .addr = 0X3056, .data = 0},
    {.name = "BLUE_GAIN", .addr = 0X3058, .data = 0},
    {.name = "RED_GAIN", .addr = 0X305A, .data = 0},
    {.name = "GREEN2_GAIN", .addr = 0X305C, .data = 0},
    {.name = "GLOBAL_GAIN", .addr = 0X305E, .data = 0},
    {.name = "ANALOG_COLOR_GAIN_T1", .addr = 0X3060, .data = 0},
    {.name = "ROW_NOISE_CONTROL", .addr = 0X3092, .data = 0},
    {.name = "NOISE_PEDESTAL", .addr = 0X30FE, .data = 0},
    {.name = "DLO_CONTROL0", .addr = 0X3100, .data = 0},
    {.name = "DLO_CONTROL1", .addr = 0X3102, .data = 0},
    {.name = "DLO_CONTROL2", .addr = 0X3104, .data = 0},
    {.name = "DLO_CONTROL3", .addr = 0X3106, .data = 0},
    {.name = "DLO_CONTROL4", .addr = 0X3108, .data = 0},
    {.name = "HDR_CONTROL0", .addr = 0X3110, .data = 0},
    {.name = "HDR_SC_CONTROL0", .addr = 0X3120, .data = 0},
    {.name = "HDR_SC_CONTROL1", .addr = 0X3122, .data = 0},
    {.name = "HDR_MD_CONTROL0", .addr = 0X3124, .data = 0},
    {.name = "HDR_MD_CONTROL1", .addr = 0X3126, .data = 0},
    {.name = "HDR_SF_CONTROL0", .addr = 0X3128, .data = 0},
    {.name = "CUSTOMER_REV", .addr = 0X31FE, .data = 0},
    {.name = "COARSE_INTEGRATION_TIME2", .addr = 0X3212, .data = 0},
    {.name = "COARSE_INTEGRATION_TIME3", .addr = 0X3216, .data = 0},
    {.name = "COARSE_INTEGRATION_TIME4", .addr = 0X321A, .data = 0},
    {.name = "FINE_INTEGRATION_TIME2", .addr = 0X321E, .data = 0},
    {.name = "FINE_INTEGRATION_TIME3", .addr = 0X3222, .data = 0},
    {.name = "FINE_INTEGRATION_TIME4", .addr = 0X3226, .data = 0},
    {.name = "FINE_CORRECTION", .addr = 0X3230, .data = 0},
    {.name = "FINE_CORRECTION2", .addr = 0X3232, .data = 0},
    {.name = "FINE_CORRECTION3", .addr = 0X3234, .data = 0},
    {.name = "FINE_CORRECTION4", .addr = 0X3236, .data = 0},
    {.name = "EXPOSURE_RATIO", .addr = 0X3238, .data = 0},
    {.name = "DC_GAIN", .addr = 0X3362, .data = 0},
    {.name = "ANALOG_GAIN", .addr = 0X3366, .data = 0},
    {.name = "DIGITAL_GAIN", .addr = 0X3308, .data = 0},
    {.name = "DBLC_PEDESTAL", .addr = 0X3386, .data = 0},
    {.name = "TPG_COLOR0_GR1_HI", .addr = 0X338A, .data = 0},
    {.name = "TPG_COLOR1_GR1_HI", .addr = 0X339A, .data = 0},
    {.name = "FRAME_COUNT_MSB", .addr = 0X2000, .data = 0},
    {.name = "FRAME_COUNT_LSB", .addr = 0X2002, .data = 0},
    {.name = "FRAME_REPORT", .addr = 0X31D2, .data = 0},
    {.name = "TEMPSENS0_CTL", .addr = 0X20B4, .data = 0},
    {.name = "TEMPSENS1_CTL", .addr = 0X20B8, .data = 0},
    {.name = "TEMPSENS0_CAL1", .addr = 0X30C6, .data = 0},
    {.name = "TEMPSENS0_CAL2", .addr = 0X30C8, .data = 0},
    {.name = "TEMPSENS1_CAL1", .addr = 0X30CA, .data = 0},
    {.name = "TEMPSENS1_CAL2", .addr = 0X30CC, .data = 0},
};

#endif /*__ISC_AR0231_REGMAP_H__*/

