/*
 * Copyright (c) 2017-2019, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef _ISC_AR0144_H_
#define _ISC_AR0144_H_

#include "nvmedia_isc.h"

#define SIZE_FUSE_ID                    16u
#define ISC_AR0144_AE_DISABLED          (1u << 0)
#define ISC_AR0144_AE_ENABLED           (1u << 1)

typedef enum {
    ISC_CONFIG_AR0144_DVP_RAW12_1280X800_60 = 0,
    ISC_CONFIG_AR0144_DVP_RAW12_1280X800_30,
    ISC_CONFIG_AR0144_ENABLE_STREAMING,
    ISC_CONFIG_AR0144_ENABLE_PG,
    ISC_CONFIG_AR0144_DISABLE_EMB_DATA,
} ConfigSetsAR0144;

typedef enum {
    ISC_READ_PARAM_CMD_AR0144_PCLK = 0,
} ReadParametersCmdAR0144;

typedef enum {
    ISC_AR0144_REV_4 = 0,
    ISC_AR0144_INVALID_REV,
} RevisionAR0144;

typedef struct {
    int32_t enumeratedDeviceConfig;
    uint32_t frameRate;
} ConfigInfoAR0144;

typedef struct {
    union {
        uint32_t pclk;
    };
} WriteReadParametersParamAR0144;

typedef struct {
    NvMediaISCModuleConfig moduleConfig;
} ContextAR0144;

NvMediaISCDeviceDriver *GetAR0144Driver(void);
NvMediaStatus GetAR0144ConfigSet(char *resolution, char *inputFormat, unsigned int framerate, int *configSet);

NvMediaStatus
AR0144CheckPresence(
    NvMediaISCDevice *handle);

NvMediaStatus
AR0144SetDefaults(
    NvMediaISCDevice *handle);

NvMediaStatus
AR0144SetDeviceConfig(
    NvMediaISCDevice *handle,
    uint32_t enumeratedDeviceConfig);

NvMediaStatus
AR0144ReadRegister(
    NvMediaISCDevice *handle,
    uint32_t deviceIndex,
    uint32_t registerNum,
    uint32_t dataLength,
    uint8_t *dataBuff);

NvMediaStatus
AR0144WriteRegister(
    NvMediaISCDevice *handle,
    uint32_t deviceIndex,
    uint32_t registerNum,
    uint32_t dataLength,
    uint8_t *dataBuff);

NvMediaStatus
AR0144ReadParameters(
    NvMediaISCDevice *handle,
    uint32_t parameterType,
    uint32_t parameterSize,
    void *parameter);

NvMediaStatus
AR0144DumpRegisters(
    NvMediaISCDevice *handle);

#endif /* _ISC_AR0144_H_ */
