/*
 * Copyright (c) 2016-2018, NVIDIA CORPORATION. All rights reserved.
 *
 * NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited.
 */

#ifndef _EGLSTRM_SETUP_H_
#define _EGLSTRM_SETUP_H_

#include "egl_utils.h"

#define SOCK_PATH       "/tmp/nvmedia_egl_socket"

/* struct to give client params of the connection */
/* struct members are read-only to client */
typedef struct _EglStreamClient {
    EGLDisplay   display;
    EGLStreamKHR eglStream;
    bool         fifoMode;
    EGLDisplay   display_dGPU;
    EGLStreamKHR eglStream_dGPU;

} EglStreamClient;

void EGLStreamPrintStateInfo(EGLint streamState);

EglStreamClient *EGLStreamSingleProcInit(EGLDisplay display,
                                         bool fifoMode,
                                         EGLDisplay display_dGPU,
                                         bool consumerondGPU);
EglStreamClient *EGLStreamProducerProcInit(EGLDisplay display,
                                           bool fifoMode);
EglStreamClient *EGLStreamConsumerProcInit(EGLDisplay display,
                                           bool fifoMode);

void EGLStreamFini(EglStreamClient *client, bool consumerondGPU);

#endif /* _EGLSTRM_SETUP_H_ */
