/*
 * Copyright (c) 2014-2018, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef _NVMEDIA_TEST_CMD_LINE_H_
#define _NVMEDIA_TEST_CMD_LINE_H_

#include <stdbool.h>
#include "display_utils.h"
#include "misc_utils.h"
#include "nvmedia_core.h"
#include "nvmedia_surface.h"
#include "nvmedia_vcp.h"
#include "nvmedia_vmp.h"
#include "testutil_board.h"
#include "testutil_capture_input.h"

#define NVMEDIA_DEINTERLACE_TYPE_WEAVE   3
#define MAX_DISPLAYS                     2

typedef struct _DisplayParams {
    int                                  displayId;
    NvMediaBool                          isEnabled;
    NvMediaBool                          isPositionSpecified;
    NvMediaRect                          position;
    unsigned int                         windowId;
    unsigned int                         depth;
} VideoDisplayParams;

typedef struct _TestArgs {
    I2cId                                i2cDevice;
    NvMediaBool                          isLiveMode;
    NvMediaBool                          checkCRC;
    unsigned int                         crcChecksum;
    NvMediaBool                          displayEnabled;
    VideoDisplayParams                   displaysList;
    int                                  logLevel;
    unsigned int                         timeout;
    char                                 configFileName[MAX_STRING_SIZE];
    char                                *paramSetName;
    unsigned int                         captureTime;
    int                                  captureCount;
    CaptureInputDeviceId                 captureDeviceInUse;
    unsigned int                         inputVideoStd;
    NvMediaBool                          fileDumpEnabled;
    char                                *outputFileName;
    float                                aspectRatio;
    unsigned int                         mixerWidth;
    unsigned int                         mixerHeight;
    unsigned int                         inputWidth;
    unsigned int                         inputHeight;

    /* csi specific params */
    NvMediaVideoCaptureInterfaceType     csiPortInUse;
    unsigned int                         csiInterfaceLaneCount;
    NvMediaVideoCaptureInputFormatType   csiInputFormat;
    NvMediaSurfaceType                   csiSurfaceType;
    NvMediaSurfAllocAttr                 csiSurfAllocAttrs[8];
    unsigned int                         csiNumSurfAllocAttrs;
    NvMediaBool                          csiCaptureInterlaced;
    NvMediaBool                          csiDeinterlaceEnabled;
    int                                  csiDeinterlaceType;
    int                                  csiDeinterlaceAlgo;
    bool                                 csiInverceTelecine;
    unsigned int                         csiExtraLines;
} TestArgs;

//  PrintUsage
//
//    PrintUsage()  Prints video demo application usage options

void PrintUsage(void);

//  ParseArgs
//
//    ParseArgs()  Parsing command line arguments
//
//  Arguments:
//
//   argc
//      (in) Number of tokens in the command line
//
//   argv
//      (in) Command line tokens
//
//   args
//      (out) Pointer to test arguments structure

int  ParseArgs(int argc, char **argv, TestArgs *args);

//  PrintOptions
//
//    PrintOptions()  Prints capture test arguments

void PrintOptions(TestArgs *args);

#endif /* _NVMEDIA_TEST_CMD_LINE_H_ */
