/*
 * Copyright (c) 2018-2020, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef _CNVMEEPROM_HPP_
#define _CNVMEEPROM_HPP_

#include "NvSIPLPlatformCfg.hpp"
#include "devblk_cdi.h"

#include "CNvMDevice.hpp"
#include "utils/utils.hpp"

namespace nvsipl
{

//! Base EEPROM class
class CNvMEEPROM : public CNvMDevice
{
public:
    CNvMEEPROM() = default;

    virtual ~CNvMEEPROM() = default;

    virtual SIPLStatus SetConfig(const EEPROMInfo *eepromInfo, DeviceParams *params);

    void SetDriverHandle(DevBlkCDIDeviceDriver *driver)
    {
        m_pCDIDriver = driver;
    }

    virtual SIPLStatus ReadData(const std::uint16_t address,
                                const std::uint32_t length,
                                std::uint8_t * const buffer);
#if !NV_IS_SAFETY
    virtual SIPLStatus WriteData(const std::uint16_t address,
                                 const std::uint32_t length,
                                 std::uint8_t * const buffer);
#endif // !NV_IS_SAFETY
};

} // end of namespace nvsipl
#endif //_CNVMEEPROM_HPP_
