/*
 * Copyright (c) 2018-2020, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef _CNVMTRANSPORTINK_MAX96712_96705_HPP_
#define _CNVMTRANSPORTINK_MAX96712_96705_HPP_

#include "TransportLinkIF/CNvMTransportLink.hpp"
#include "utils/utils.hpp"

namespace nvsipl
{

class CNvMTransportLink_Max96712_96705 final: public CNvMTransportLink
{
public:
    SIPLStatus Init(DevBlkCDIDevice* brdcstSerCDI, uint8_t linkMask, bool groupInitProg) override;

    SIPLStatus PostSensorInit(DevBlkCDIDevice* brdcstSerCDI, uint8_t linkMask, bool groupInitProg) override;

    SIPLStatus MiscInit() override;

    SIPLStatus Reset() override;

    bool IsGMSL2() override {return false;};

private:
    // Dump link Parameters
    void DumpLinkParams();

    // Setup config link
    SIPLStatus SetupConfigLink(DevBlkCDIDevice* brdcstSerCDI, uint8_t linkMask, bool groupInitProg);

    // Setup serializer address translations
    SIPLStatus SetupAddressTranslationsSer(DevBlkCDIDevice* brdcstSerCDI, bool groupInitProg);

    // Setup eeprom address translations
    SIPLStatus SetupAddressTranslationsEEPROM();

    // Setup video link
    SIPLStatus SetupVideoLink();
};

} // end of namespace nvsipl
#endif // _CNVMTRANSPORTINK_MAX96712_96705_HPP_
