/* Copyright (c) 2015-2018, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef _DEV_PRIV_H_
#define _DEV_PRIV_H_

#include "img_dev.h"

typedef struct {
    char                       *resolution; /* resolution, ex)"1280x800" */
    uint32_t                    osc; /* image device OSC value, unit is MHz.
                                      * If OSC is 24MHz, the value is 24 */
    uint32_t                    frameRate; /* frame per second */
    float_t                     dutyRatio; /* duty ratio */
    uint32_t                    pixelFrequency; /* In general, pixelFreq can be calculated as VTS x HTS x frame rate (Hz).
                                                   But in some sensors, pixelFreq may be dictated by PLL setting of PCLK. */
    uint32_t                    mipiSpeed[2];   /* in a case of fixed MIPI speed in kHz regardless of the sensor module
                                                   index 0 is for DPHY, index 1 is for CPHY */
    uint32_t                    embLinesTop; /* number of lines for emb data */
    uint32_t                    embLinesBottom; /* number of lines for emb data */
    NvMediaBool                 embDataType; /* embedded lines come with embedded data type in CSI packets */
    char                       *inputFormat; /* 422p(yuv8bit), 422p10(yuv10bit), raw12 */
    char                       *pixelOrder; /* bggr */
} ImgProperty;

typedef struct {
    char *name;
    ExtImgDevice *(*Init)(ExtImgDevParam *param);
    void (*Deinit)(ExtImgDevice *device);
    NvMediaStatus (*RegisterCallback)(ExtImgDevice *device, uint32_t sigNum, void (*cb)(void *), void *context);
    NvMediaStatus (*GetError)(ExtImgDevice *device, uint32_t *link, ExtImgDevFailureType *errorType);
    ImgProperty    *properties;
    uint32_t       numProperties;
    NvMediaStatus (*Start)(ExtImgDevice *device);
} ImgDevDriver;

#endif /* _DEV_PRIV_H_ */
