/*
 * Copyright (c) 2016-2020, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef _ISC_AR0231_RCCB_H_
#define _ISC_AR0231_RCCB_H_

#include "nvmedia_isc.h"
#define AR0231_NUM_HDR_EXP         3u
#define AR0231_REG_PLL_VT_PIXDIV   0x302A
#define ISC_AR0231_T1_EXPOSURE     0u
#define ISC_AR0231_T2_EXPOSURE     1u
#define ISC_AR0231_T3_EXPOSURE     2u

typedef enum {
    ISC_CONFIG_AR0231_DVP_RAW12_COMP_1920X1208 = 0,  // default
    ISC_CONFIG_AR0231_RESET_FRAME_ID,
    ISC_CONFIG_AR0231_ENABLE_BOTTOM_EMB,
    ISC_CONFIG_AR0231_DVP_RAW12_COMP_1920X1008,
    ISC_CONFIG_AR0231_ENABLE_STREAMING,
    ISC_CONFIG_AR0231_ENABLE_MIPI_STREAMING,
    ISC_CONFIG_AR0231_ENABLE_MIPI_IF,
    ISC_CONFIG_AR0231_ENABLE_PG,
}ConfigSetsAR0231;

typedef enum {
    ISC_CONFIG_AR0231_1920X1208_30FPS,
    ISC_CONFIG_AR0231_1920X1008,
    ISC_CONFIG_AR0231_NUM_RESOLUTION,
} ConfigResolutionAR0231;

typedef enum {
    ISC_CONFIG_AR0231_CONFIG_SET0 = 0, // internal sync
    ISC_CONFIG_AR0231_CONFIG_SET1,     // external sync
    ISC_CONFIG_AR0231_NUM_CONFIG_SET,
} ConfigSetAR0231;

typedef enum {
    ISC_READ_PARAM_CMD_AR0231_CONFIG_INFO = 0,
    ISC_READ_PARAM_CMD_AR0231_EXP_LINE_RATE,
    ISC_READ_PARAM_CMD_AR0231_FUSE_ID,
} ReadParametersCmdAR0231;

typedef enum {
    ISC_WRITE_PARAM_CMD_AR0231_CONFIG_INFO = 0,
} WriteParametersCmdAR0231;

typedef enum {
    AR0231_OSC_25MHZ = 25u,
    AR0231_OSC_27MHZ = 27u,
} AR0231OSCMHZ;

typedef struct {
    float_t exposureLineRate;
    int32_t enumeratedDeviceConfig;
    ConfigResolutionAR0231 resolution;
    uint32_t frameRate;
    float_t maxGain;
    uint8_t sensorVersion;
} ConfigInfoAR0231;

typedef struct {
    union {
        ConfigInfoAR0231 *configInfo;
    };
} WriteReadParametersParamAR0231;

typedef struct {
    uint32_t    oscMHz;
    NvMediaISCModuleConfig  moduleConfig;
    float_t     maxGain;
    uint32_t    frameRate;
    uint32_t    width;
    uint32_t    configSetIdx;
    uint32_t    embDataType;
    uint32_t    patternMode; /* Test Pattern Mode:
                                    0: Default Pattern (equals mode 2)
                                    1: Default Solid Color (NV-Green: RGB=0x76b900)
                                    2: Vertical Color Bars
                                    3: Fade-to-Gray Vertical Color Bars
                                    256: Walking 1s (non-fixed pattern, NOT suitable for CRC test)
                                    > 256: Customized Solid Color (RGB=patternMode[31:8]) */
} ContextAR0231;

typedef enum {
    EMB_PARSED = 0,
    EMB_UNPARSED,
}EmbeddedDataType;

NvMediaISCDeviceDriver *GetAR0231RccbDriver(void);
NvMediaStatus GetAR0231RccbConfigSet(char *resolution, char *inputFormat, int *configSet, unsigned int framerate);

NvMediaStatus
AR0231RCCBCheckPresence(
    NvMediaISCDevice *handle);

NvMediaStatus
AR0231RCCBSetDefaults(
    NvMediaISCDevice *handle);

NvMediaStatus
AR0231RCCBSetDeviceConfig(
    NvMediaISCDevice *handle,
    uint32_t enumeratedDeviceConfig);

NvMediaStatus
AR0231RCCBReadRegister(
    NvMediaISCDevice *handle,
    uint32_t deviceIndex,
    uint32_t registerNum,
    uint32_t dataLength,
    uint8_t *dataBuff);

NvMediaStatus
AR0231RCCBWriteRegister(
    NvMediaISCDevice *handle,
    uint32_t deviceIndex,
    uint32_t registerNum,
    uint32_t dataLength,
    uint8_t *dataBuff);

NvMediaStatus
AR0231RCCBWriteParameters(
    NvMediaISCDevice *handle,
    uint32_t parameterType,
    uint32_t parameterSize,
    void *parameter);

NvMediaStatus
AR0231RCCBReadParameters(
    NvMediaISCDevice *handle,
    uint32_t parameterType,
    uint32_t parameterSize,
    void *parameter);

NvMediaStatus
AR0231RCCBDumpRegisters(
    NvMediaISCDevice *handle);

#endif /* _ISC_AR0231_RCCB_H_ */
