/*
 * Copyright (c) 2019, NVIDIA CORPORATION.  All rights reserved. All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef _UTILS_H_
#define _UTILS_H_

#include <cstdint>
#include <string>
#include "cLogger.h"

#define CHECK_FAIL(condition, message, ...)                        \
    do {                                                           \
        if( !(condition)) {                                        \
            LOG_ERR("%s Fail\n", message, ## __VA_ARGS__);         \
            goto fail ;                                            \
        } else {                                                   \
            LOG_DBG("%s Successful\n", message, ## __VA_ARGS__);  \
        }                                                          \
    } while (0)

#define PROPAGATE_ERROR_FAIL(condition, message, ...) \
    do {                                                           \
        if( !(condition)) {                                        \
            LOG_ERR("%s Fail\n", message, ## __VA_ARGS__);         \
            status = NVMEDIA_STATUS_ERROR;                         \
            goto fail ;                                            \
        } else {                                                   \
            LOG_DBG("%s Successful\n", message, ## __VA_ARGS__);  \
        }                                                          \
    } while (0)

uint8_t *
readFileToMemory(
    std::string fileName,
    uint64_t &fileSize
);

#endif // end of _UTILS_H_
