/*
 * File: SOH.c
 *
 * Code generated for Simulink model 'SOH'.
 *
 * Company                        : AIWAYS
 * Author                         : wangq6
 * Model version                  : 'M124C104'
 * Simulink Coder version         : 8.13 (R2017b) 24-Jul-2017
 * C/C++ source code generated on : Thu Jun 16 15:28:05 2022
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: Infineon->TriCore
 * Code generation objectives:
 *    1. MISRA C:2012 guidelines
 *    2. Safety precaution
 * Validation result: Not run
 */

#include "SOH.h"
#include "SOH_private.h"
#include "look1_iflf_binlcapw.h"
#include "look1_iu16lftf_binlcapw.h"
#include "look1_iu32lftf_binlcapw.h"

/* Block signals (auto storage) */
B_SOH_T SOH_B;

/* Block states (auto storage) */
DW_SOH_T SOH_DW;

/*
 * Output and update for action system:
 *    '<S73>/Switch Case Action Subsystem'
 *    '<S73>/Switch Case Action Subsystem3'
 */
void SOH_SwitchCaseActionSubsystem(uint32_T rtu_ISP_BreakpointVar, real32_T
  *rty_Case_Output)
{
  *rty_Case_Output = look1_iu32lftf_binlcapw(rtu_ISP_BreakpointVar, ((const
    uint32_T *)&(CaSOH_CATL177CalenderDayTable1_Day[0])), ((const real32_T *)
    &(CaSOH_CalenderSOH_pct[0])), 39U);
}

/*
 * Output and update for action system:
 *    '<S73>/Switch Case Action Subsystem1'
 *    '<S73>/Switch Case Action Subsystem2'
 *    '<S73>/Switch Case Action Subsystem5'
 *    '<S73>/Switch Case Action Subsystem6'
 *    '<S73>/Switch Case Action Subsystem8'
 *    '<S73>/Switch Case Action Subsystem9'
 */
void SOH_SwitchCaseActionSubsystem1(uint32_T rtu_ISP_BreakpointVar, real32_T
  *rty_Case_Output)
{
  *rty_Case_Output = look1_iu32lftf_binlcapw(rtu_ISP_BreakpointVar, ((const
    uint32_T *)&(CaSOH_TFE177CalenderDayTable1_Day[0])), ((const real32_T *)
    &(CaSOH_CalenderSOH_pct[0])), 39U);
}

/*
 * Output and update for action system:
 *    '<S74>/Switch Case Action Subsystem'
 *    '<S74>/Switch Case Action Subsystem3'
 */
void SOH_SwitchCaseActionSubsystem_l(uint32_T rtu_ISP_BreakpointVar, real32_T
  *rty_Case_Output)
{
  *rty_Case_Output = look1_iu32lftf_binlcapw(rtu_ISP_BreakpointVar, ((const
    uint32_T *)&(CaSOH_CATL177CalenderDayTable2_Day[0])), ((const real32_T *)
    &(CaSOH_CalenderSOH_pct[0])), 39U);
}

/*
 * Output and update for action system:
 *    '<S74>/Switch Case Action Subsystem1'
 *    '<S74>/Switch Case Action Subsystem2'
 *    '<S74>/Switch Case Action Subsystem5'
 *    '<S74>/Switch Case Action Subsystem6'
 *    '<S74>/Switch Case Action Subsystem8'
 *    '<S74>/Switch Case Action Subsystem9'
 */
void SO_SwitchCaseActionSubsystem1_k(uint32_T rtu_ISP_BreakpointVar, real32_T
  *rty_Case_Output)
{
  *rty_Case_Output = look1_iu32lftf_binlcapw(rtu_ISP_BreakpointVar, ((const
    uint32_T *)&(CaSOH_TFE177CalenderDayTable2_Day[0])), ((const real32_T *)
    &(CaSOH_CalenderSOH_pct[0])), 39U);
}

/*
 * Output and update for action system:
 *    '<S75>/Switch Case Action Subsystem'
 *    '<S75>/Switch Case Action Subsystem3'
 */
void SOH_SwitchCaseActionSubsystem_o(uint32_T rtu_ISP_BreakpointVar, real32_T
  *rty_Case_Output)
{
  *rty_Case_Output = look1_iu32lftf_binlcapw(rtu_ISP_BreakpointVar, ((const
    uint32_T *)&(CaSOH_CATL177CalenderDayTable3_Day[0])), ((const real32_T *)
    &(CaSOH_CalenderSOH_pct[0])), 39U);
}

/*
 * Output and update for action system:
 *    '<S75>/Switch Case Action Subsystem1'
 *    '<S75>/Switch Case Action Subsystem2'
 *    '<S75>/Switch Case Action Subsystem5'
 *    '<S75>/Switch Case Action Subsystem6'
 *    '<S75>/Switch Case Action Subsystem8'
 *    '<S75>/Switch Case Action Subsystem9'
 */
void SO_SwitchCaseActionSubsystem1_o(uint32_T rtu_ISP_BreakpointVar, real32_T
  *rty_Case_Output)
{
  *rty_Case_Output = look1_iu32lftf_binlcapw(rtu_ISP_BreakpointVar, ((const
    uint32_T *)&(CaSOH_TFE177CalenderDayTable3_Day[0])), ((const real32_T *)
    &(CaSOH_CalenderSOH_pct[0])), 39U);
}

/*
 * Output and update for action system:
 *    '<S76>/Switch Case Action Subsystem'
 *    '<S76>/Switch Case Action Subsystem3'
 */
void SO_SwitchCaseActionSubsystem_ob(uint32_T rtu_ISP_BreakpointVar, real32_T
  *rty_Case_Output)
{
  *rty_Case_Output = look1_iu32lftf_binlcapw(rtu_ISP_BreakpointVar, ((const
    uint32_T *)&(CaSOH_CATL177CalenderDayTable4_Day[0])), ((const real32_T *)
    &(CaSOH_CalenderSOH_pct[0])), 39U);
}

/*
 * Output and update for action system:
 *    '<S76>/Switch Case Action Subsystem1'
 *    '<S76>/Switch Case Action Subsystem2'
 *    '<S76>/Switch Case Action Subsystem5'
 *    '<S76>/Switch Case Action Subsystem6'
 *    '<S76>/Switch Case Action Subsystem8'
 *    '<S76>/Switch Case Action Subsystem9'
 */
void SO_SwitchCaseActionSubsystem1_e(uint32_T rtu_ISP_BreakpointVar, real32_T
  *rty_Case_Output)
{
  *rty_Case_Output = look1_iu32lftf_binlcapw(rtu_ISP_BreakpointVar, ((const
    uint32_T *)&(CaSOH_TFE177CalenderDayTable4_Day[0])), ((const real32_T *)
    &(CaSOH_CalenderSOH_pct[0])), 39U);
}

/*
 * Output and update for action system:
 *    '<S118>/Switch Case Action Subsystem'
 *    '<S118>/Switch Case Action Subsystem1'
 *    '<S118>/Switch Case Action Subsystem2'
 *    '<S118>/Switch Case Action Subsystem3'
 *    '<S118>/Switch Case Action Subsystem5'
 *    '<S118>/Switch Case Action Subsystem6'
 *    '<S118>/Switch Case Action Subsystem9'
 */
void SOH_SwitchCaseActionSubsystem_d(real32_T rtu_ISP_BreakpointVar, real32_T
  *rty_Case_Output)
{
  *rty_Case_Output = look1_iflf_binlcapw(rtu_ISP_BreakpointVar, ((const real32_T
    *)&(CaSOH_CATL177CycleCapAhTable1_Ah[0])), ((const real32_T *)
    &(CaSOH_CycleSOH_pct[0])), 39U);
}

/*
 * Output and update for action system:
 *    '<S119>/Switch Case Action Subsystem'
 *    '<S119>/Switch Case Action Subsystem1'
 *    '<S119>/Switch Case Action Subsystem2'
 *    '<S119>/Switch Case Action Subsystem3'
 *    '<S119>/Switch Case Action Subsystem5'
 *    '<S119>/Switch Case Action Subsystem6'
 *    '<S119>/Switch Case Action Subsystem9'
 */
void SOH_SwitchCaseActionSubsystem_p(real32_T rtu_ISP_BreakpointVar, real32_T
  *rty_Case_Output)
{
  *rty_Case_Output = look1_iflf_binlcapw(rtu_ISP_BreakpointVar, ((const real32_T
    *)&(CaSOH_CATL177CycleCapAhTable2_Ah[0])), ((const real32_T *)
    &(CaSOH_CycleSOH_pct[0])), 39U);
}

/*
 * Output and update for action system:
 *    '<S120>/Switch Case Action Subsystem'
 *    '<S120>/Switch Case Action Subsystem1'
 *    '<S120>/Switch Case Action Subsystem2'
 *    '<S120>/Switch Case Action Subsystem3'
 *    '<S120>/Switch Case Action Subsystem5'
 *    '<S120>/Switch Case Action Subsystem6'
 *    '<S120>/Switch Case Action Subsystem9'
 */
void SOH_SwitchCaseActionSubsystem_m(real32_T rtu_ISP_BreakpointVar, real32_T
  *rty_Case_Output)
{
  *rty_Case_Output = look1_iflf_binlcapw(rtu_ISP_BreakpointVar, ((const real32_T
    *)&(CaSOH_CATL177CycleCapAhTable3_Ah[0])), ((const real32_T *)
    &(CaSOH_CycleSOH_pct[0])), 39U);
}

/*
 * Output and update for action system:
 *    '<S121>/Switch Case Action Subsystem'
 *    '<S121>/Switch Case Action Subsystem1'
 *    '<S121>/Switch Case Action Subsystem2'
 *    '<S121>/Switch Case Action Subsystem3'
 *    '<S121>/Switch Case Action Subsystem5'
 *    '<S121>/Switch Case Action Subsystem6'
 *    '<S121>/Switch Case Action Subsystem9'
 */
void SOH_SwitchCaseActionSubsystem_j(real32_T rtu_ISP_BreakpointVar, real32_T
  *rty_Case_Output)
{
  *rty_Case_Output = look1_iflf_binlcapw(rtu_ISP_BreakpointVar, ((const real32_T
    *)&(CaSOH_CATL177CycleCapAhTable4_Ah[0])), ((const real32_T *)
    &(CaSOH_CycleSOH_pct[0])), 39U);
}

/*
 * Output and update for action system:
 *    '<S165>/Switch Case Action Subsystem'
 *    '<S165>/Switch Case Action Subsystem1'
 *    '<S165>/Switch Case Action Subsystem2'
 *    '<S165>/Switch Case Action Subsystem3'
 *    '<S165>/Switch Case Action Subsystem5'
 *    '<S165>/Switch Case Action Subsystem6'
 *    '<S165>/Switch Case Action Subsystem9'
 */
void SOH_SwitchCaseActionSubsystem_f(real32_T rtu_ISP_BreakpointVar, real32_T
  *rty_Case_Output)
{
  *rty_Case_Output = look1_iflf_binlcapw(rtu_ISP_BreakpointVar, ((const real32_T
    *)&(CaSOH_CATL177QACapAhTable_Ah[0])), ((const real32_T *)
    &(CaSOH_QAOdoLossSOH_pct[0])), 39U);
}

/*
 * Output and update for action system:
 *    '<S177>/Switch Case Action Subsystem'
 *    '<S177>/Switch Case Action Subsystem1'
 *    '<S177>/Switch Case Action Subsystem2'
 *    '<S177>/Switch Case Action Subsystem3'
 *    '<S177>/Switch Case Action Subsystem5'
 *    '<S177>/Switch Case Action Subsystem6'
 *    '<S177>/Switch Case Action Subsystem9'
 */
void SO_SwitchCaseActionSubsystem_fi(uint32_T rtu_ISP_BreakpointVar, real32_T
  *rty_Case_Output)
{
  *rty_Case_Output = look1_iu32lftf_binlcapw(rtu_ISP_BreakpointVar, ((const
    uint32_T *)&(CaSOH_CATL177QAUsageTable_Day[0])), ((const real32_T *)
    &(CaSOH_QAUsageLossSOH_pct[0])), 39U);
}

/* Model step function */
void SOH_CapUpdate_Init(void)
{
  int16_T s191_iter;
  real32_T StateName;
  real32_T StateName_k;
  uint8_T StateName_p;
  real32_T StateName_h;
  StateName = 0.0F;
  StateName_k = 0.0F;
  StateName_p = 1U;
  StateName_h = 0.0F;
  for (s191_iter = 1; s191_iter <= get_GcUDS_CellVoltNum_numb(); s191_iter++)
  {
    LcSOH_SumCellCap_Ah = get_EaNVM_AllCellCap_Ah( s191_iter - 1 ) + StateName;
    if (StateName_p != 0)
    {
      StateName_h = get_EaNVM_AllCellCap_Ah( s191_iter - 1 );
    }

    if (StateName_h >= get_EaNVM_AllCellCap_Ah( s191_iter - 1 ))
    {
      LcSOH_MinCellCap_Ah = get_EaNVM_AllCellCap_Ah( s191_iter - 1 );
    }
    else
    {
      LcSOH_MinCellCap_Ah = StateName_k;
    }

    StateName = LcSOH_SumCellCap_Ah;
    StateName_p = 0U;
    StateName_h = LcSOH_MinCellCap_Ah;
    StateName_k = LcSOH_MinCellCap_Ah;
  }

  StateName = LcSOH_SumCellCap_Ah / (real32_T)get_GcUDS_CellVoltNum_numb();
  if (get_GcUDS_BatCap_Ah() < StateName)
  {
    StateName = get_GcUDS_BatCap_Ah();
  }

  if (StateName > SOH_Const0_Numb)
  {
    LcSOH_CurrBatCap_Ah = StateName;
  }
  else
  {
    LcSOH_CurrBatCap_Ah = (real32_T)SOH_Const0_Numb;
  }

  if (CbSOH_PackSOH1OvrSwt_flg)
  {
    set_GcSOH_PackSOH1_pct(CcSOH_PackSOH1Ovr_pct);
  }
  else
  {
    set_GcSOH_PackSOH1_pct(LcSOH_CurrBatCap_Ah / (real32_T)get_GcUDS_BatCap_Ah());
  }
}

/* Model step function */
void SOH_CapCal_10ms(void)
{
  real32_T rtb_Switch4;
  real32_T rtb_Divide_m;
  boolean_T rtb_LogicalOperator2;
  int16_T s44_iter;
  boolean_T rtb_RelationalOperator_a;
  boolean_T rtb_RelationalOperator_cp;
  boolean_T rtb_RelationalOperator_im;
  uint32_T rtb_Switch2_g;
  real32_T rtb_Switch_fm[112];
  boolean_T rtb_RelationalOperator_mj[112];
  Enum_SOHCapFltState rtb_Switch1_f;
  uint16_T rtb_Switch2_bl;
  uint16_T rtb_Switch2_kx;
  int32_T i;
  uint8_T rtb_LogicalOperator2_0;
  rtb_Divide_m = get_GcHDP_PackCrnt_A() * (real32_T)SOH_Runtime10_ms / (real32_T)
    ((uint32_T)SOH_Const1000_Numb * SOH_Const3600_Numb);
  if (get_EcNVM_NVMOCVCorrdSign_numb() == SOH_Const165_Numb)
  {
    rtb_Switch4 = rtb_Divide_m;
  }
  else
  {
    rtb_Switch4 = SOH_Const0_Numb;
  }

  rtb_Switch4 = get_EcNVM_CellAbsvCap_Ah() + fabsf(rtb_Switch4);
  rtb_LogicalOperator2 = ((get_GbHDP_PackCrntVld_flg() == ((boolean_T)
    ASWTYPE_FALSE)) && (fabsf(get_EcNVM_CellChrgDisCap_Ah()) > SOH_Const0_Numb));
  if (SOH_DW.StateName_a2)
  {
    rtb_Switch2_bl = 0U;
  }
  else
  {
    rtb_Switch2_bl = SOH_DW.StateName_o;
  }

  if (rtb_LogicalOperator2)
  {
    rtb_Switch2_bl = (uint16_T)((uint32_T)SOH_Runtime10_ms + rtb_Switch2_bl);
    if (!(rtb_Switch2_bl < 60000))
    {
      rtb_Switch2_bl = 60000U;
    }
  }
  else if (rtb_Switch2_bl >= SOH_Runtime10_ms)
  {
    rtb_Switch2_bl = (uint16_T)((uint32_T)rtb_Switch2_bl - SOH_Runtime10_ms);
  }
  else
  {
    rtb_Switch2_bl = 0U;
  }

  rtb_RelationalOperator_cp = (rtb_Switch2_bl > CcSOH_VoltCurrVldDebTi_ms);
  if (SOH_DW.StateName_bv)
  {
    rtb_Switch2_kx = 0U;
  }
  else
  {
    rtb_Switch2_kx = SOH_DW.StateName_a;
  }

  if (!rtb_LogicalOperator2)
  {
    rtb_Switch2_kx = (uint16_T)((uint32_T)SOH_Runtime10_ms + rtb_Switch2_kx);
    if (!(rtb_Switch2_kx < 60000))
    {
      rtb_Switch2_kx = 60000U;
    }
  }
  else if (rtb_Switch2_kx >= SOH_Runtime10_ms)
  {
    rtb_Switch2_kx = (uint16_T)((uint32_T)rtb_Switch2_kx - SOH_Runtime10_ms);
  }
  else
  {
    rtb_Switch2_kx = 0U;
  }

  rtb_RelationalOperator_im = (rtb_Switch2_kx > CcSOH_VoltCurrVldDebTi_ms);
  if (!SOH_DW.StateName_p5)
  {
    rtb_LogicalOperator2 = (rtb_RelationalOperator_cp || SOH_DW.StateName_p5);
  }
  else
  {
    rtb_LogicalOperator2 = ((!rtb_RelationalOperator_im) && SOH_DW.StateName_p5);
  }

  SOH_DW.StateName_p5 = rtb_LogicalOperator2;
  SOH_DW.StateName_a2 = rtb_RelationalOperator_cp;
  SOH_DW.StateName_o = rtb_Switch2_bl;
  SOH_DW.StateName_bv = rtb_RelationalOperator_im;
  SOH_DW.StateName_a = rtb_Switch2_kx;
  rtb_RelationalOperator_cp = ((boolean_T)ASWTYPE_TRUE);
  for (s44_iter = 1; s44_iter <= get_GcUDS_CellVoltNum_numb(); s44_iter++)
  {
    SOH_B.LogicalOperator = (get_GaNVM_ReadAllCellOCVSOCVld_flg( s44_iter - 1 ) &&
      rtb_RelationalOperator_cp);
    rtb_RelationalOperator_cp = SOH_B.LogicalOperator;
  }

  if (SOH_DW.StateName_li && (get_EcNVM_NVMOCVCorrdSign_numb() ==
       SOH_Const165_Numb))
  {
    rtb_Switch2_g = (uint32_T)SOH_Const1000_Numb * SOH_Const60_Numb *
      get_GcRTC_SleepTime_min();
  }
  else if (get_EcNVM_NVMOCVCorrdSign_numb() == SOH_Const165_Numb)
  {
    rtb_Switch2_g = SOH_Runtime10_ms;
  }
  else
  {
    rtb_Switch2_g = SOH_Const0_Numb;
  }

  rtb_Switch2_g += get_EcNVM_NVMOCVCorrdSumTi_ms();
  LbSOH_NvmDataClr_flg = ((rtb_Switch4 > CcSOH_CellAbsvCap_Ah) ||
    rtb_LogicalOperator2 || (SOH_B.LogicalOperator == ((boolean_T)ASWTYPE_FALSE))
    || (CcSOH_NVMOCVCorrdSumTi_ms < rtb_Switch2_g));
  if (LbSOH_NvmDataClr_flg)
  {
    rtb_Switch2_g = SOH_Const0_Numb;
    rtb_Switch4 = SOH_Const0_Numb;
  }

  set_EcNVM_NVMOCVCorrdSumTi_ms(rtb_Switch2_g);
  set_EcNVM_CellAbsvCap_Ah(rtb_Switch4);
  if (LbSOH_NvmDataClr_flg)
  {
    rtb_Switch4 = SOH_Const0_Numb;
  }
  else
  {
    if (get_EcNVM_NVMOCVCorrdSign_numb() == SOH_Const165_Numb)
    {
      rtb_Switch4 = rtb_Divide_m;
    }
    else
    {
      rtb_Switch4 = SOH_Const0_Numb;
    }

    rtb_Switch4 += get_EcNVM_CellChrgDisCap_Ah();
  }

  set_EcNVM_CellChrgDisCap_Ah(rtb_Switch4);
  rtb_Switch4 = (real32_T)((uint32_T)get_GcUDS_BatCap_Ah() * SOH_Const3600_Numb)
    * (real32_T)SOH_Const1000_Numb;
  rtb_Divide_m = get_EcNVM_SumAbsvCap_Ah() + fabsf(rtb_Divide_m);
  if (rtb_Switch4 < rtb_Divide_m)
  {
    rtb_Divide_m = rtb_Switch4;
  }

  if (rtb_Divide_m > SOH_Const0_Numb)
  {
    set_EcNVM_SumAbsvCap_Ah(rtb_Divide_m);
  }
  else
  {
    set_EcNVM_SumAbsvCap_Ah((real32_T)SOH_Const0_Numb);
  }

  if (LbSOH_NvmDataClr_flg)
  {
    set_EcNVM_NVMOCVCorrdSign_numb(SOH_Const0_Numb);
  }

  rtb_RelationalOperator_cp = (SOH_DW.StateName_b || LbSOH_NvmDataClr_flg);
  rtb_RelationalOperator_im = !((boolean_T)ASWTYPE_TRUE);
  if (rtb_RelationalOperator_im || (SOH_DW.FixPtUnitDelay2_DSTATE_f != 0))
  {
    rtb_Switch2_bl = 0U;
  }
  else
  {
    rtb_Switch2_bl = SOH_DW.FixPtUnitDelay1_DSTATE_l;
  }

  rtb_LogicalOperator2 = (rtb_Switch2_bl >= CcSOH_OCVCorrectRunTime_ms);
  if (rtb_RelationalOperator_im)
  {
    SOH_DW.FixPtUnitDelay1_DSTATE_l = 0U;
  }
  else
  {
    if (rtb_LogicalOperator2)
    {
      rtb_LogicalOperator2_0 = 0U;
    }
    else
    {
      rtb_LogicalOperator2_0 = SOH_Runtime10_ms;
    }

    SOH_DW.FixPtUnitDelay1_DSTATE_l = (uint16_T)((uint32_T)
      rtb_LogicalOperator2_0 + rtb_Switch2_bl);
  }

  SOH_DW.FixPtUnitDelay2_DSTATE_f = 0U;
  if (SOH_DW.StateName_l != 0)
  {
    rtb_Switch2_bl = get_GcCDP_MaxCellVolt_mV();
    rtb_Switch2_kx = get_GcCDP_MinCellVolt_mV();
  }
  else
  {
    rtb_Switch2_bl = SOH_DW.StateName_ki[0];
    rtb_Switch2_kx = SOH_DW.StateName_ki[1];
  }

  SOH_DW.StateName_l = 0U;
  SOH_DW.StateName_ki[0] = get_GcCDP_MaxCellVolt_mV();
  SOH_DW.StateName_ki[1] = get_GcCDP_MinCellVolt_mV();
  if (rtb_Switch2_bl >= get_GcCDP_MaxCellVolt_mV())
  {
    rtb_Switch2_bl = (uint16_T)((uint32_T)rtb_Switch2_bl -
      get_GcCDP_MaxCellVolt_mV());
  }
  else
  {
    rtb_Switch2_bl = (uint16_T)((uint32_T)get_GcCDP_MaxCellVolt_mV() -
      rtb_Switch2_bl);
  }

  if (rtb_Switch2_kx >= get_GcCDP_MinCellVolt_mV())
  {
    rtb_Switch2_kx = (uint16_T)((uint32_T)rtb_Switch2_kx -
      get_GcCDP_MinCellVolt_mV());
  }
  else
  {
    rtb_Switch2_kx = (uint16_T)((uint32_T)get_GcCDP_MinCellVolt_mV() -
      rtb_Switch2_kx);
  }

  rtb_RelationalOperator_im = !((((boolean_T)ASWTYPE_TRUE) ==
    get_GbCDP_SumCellVoltVld_flg()) && ((rtb_Switch2_bl <=
    CcSOH_OCVPeakCellVoltDev_mV) && (rtb_Switch2_kx <=
    CcSOH_OCVPeakCellVoltDev_mV)));
  if (rtb_RelationalOperator_im || (SOH_DW.FixPtUnitDelay2_DSTATE_d != 0))
  {
    rtb_Switch2_bl = 0U;
  }
  else
  {
    rtb_Switch2_bl = SOH_DW.FixPtUnitDelay1_DSTATE_j;
  }

  rtb_RelationalOperator_a = (rtb_Switch2_bl >= CcSOH_OCVPeakCellVoltTime_ms);
  if (rtb_RelationalOperator_im)
  {
    SOH_DW.FixPtUnitDelay1_DSTATE_j = 0U;
  }
  else
  {
    if (rtb_RelationalOperator_a)
    {
      rtb_LogicalOperator2_0 = 0U;
    }
    else
    {
      rtb_LogicalOperator2_0 = SOH_Runtime10_ms;
    }

    SOH_DW.FixPtUnitDelay1_DSTATE_j = (uint16_T)((uint32_T)
      rtb_LogicalOperator2_0 + rtb_Switch2_bl);
  }

  SOH_DW.FixPtUnitDelay2_DSTATE_d = 0U;
  LbSOH_AutoOCVCorrect_flg = (((get_GeMSM_BMUState_enum() == (int32_T)
    Enum_MSMBMUState_Standby) && (!rtb_LogicalOperator2) &&
    rtb_RelationalOperator_a && (get_GcRTC_SleepTime_min() >=
    CcSOH_OCVCorrectSleepTime_min) && (((boolean_T)ASWTYPE_TRUE) ==
    get_GbCDP_AllCellTempVld_flg()) && (get_GcCDP_AvgCellTemp_C() >=
    CcSOH_OCVCorrectTemp_C)) || CbSOH_ManuOCVCorrect_flg);
  rtb_LogicalOperator2 = ((rtb_RelationalOperator_cp == ((boolean_T)
    ASWTYPE_FALSE)) && LbSOH_AutoOCVCorrect_flg);
  rtb_RelationalOperator_im = !SOH_DW.UnitDelay_DSTATE;
  SOH_DW.UnitDelay_DSTATE = rtb_LogicalOperator2;
  if (rtb_LogicalOperator2 && rtb_RelationalOperator_im)
  {
    if (!SOH_DW.NVMOCVSOH_Calculation_MODE)
    {
      SOH_DW.NVMOCVSOH_Calculation_MODE = true;
    }

    rtb_Divide_m = fabsf(get_EcNVM_CellChrgDisCap_Ah());
    switch ((int32_T)get_GeUDS_CapSel_enum())
    {
     case Enum_UDSCapSel_Default:
      for (i = 0; i < 112; i++)
      {
        SOH_B.Merge_oa[i] = look1_iu16lftf_binlcapw(get_GaCDP_CellVolt_mV( i ),
          ((const uint16_T *)&(CaSOH_CATL203ChrgOCVSOCCellVolt_mV[0])), ((const
          real32_T *)&(CaSOH_CATL203ChrgOCVSOCCellSOC_pct[0])), 29U);
      }
      break;

     case Enum_UDSCapSel_CATL153Ah:
      for (i = 0; i < 112; i++)
      {
        SOH_B.Merge_oa[i] = look1_iu16lftf_binlcapw(get_GaCDP_CellVolt_mV( i ),
          ((const uint16_T *)&(CaSOH_TFE177ChrgOCVSOCCellVolt_mV[0])), ((const
          real32_T *)&(CaSOH_TFE177ChrgOCVSOCCellSOC_pct[0])), 29U);
      }
      break;

     case Enum_UDSCapSel_CATL180Ah:
      for (i = 0; i < 112; i++)
      {
        SOH_B.Merge_oa[i] = look1_iu16lftf_binlcapw(get_GaCDP_CellVolt_mV( i ),
          ((const uint16_T *)&(CaSOH_TFE177ChrgOCVSOCCellVolt_mV[0])), ((const
          real32_T *)&(CaSOH_TFE177ChrgOCVSOCCellSOC_pct[0])), 29U);
      }
      break;

     case Enum_UDSCapSel_CATL177Ah:
      for (i = 0; i < 112; i++)
      {
        SOH_B.Merge_oa[i] = look1_iu16lftf_binlcapw(get_GaCDP_CellVolt_mV( i ),
          ((const uint16_T *)&(CaSOH_CATL177ChrgOCVSOCCellVolt_mV[0])), ((const
          real32_T *)&(CaSOH_CATL177ChrgOCVSOCCellSOC_pct[0])), 29U);
      }
      break;

     case Enum_UDSCapSel_CATL203Ah:
      for (i = 0; i < 112; i++)
      {
        SOH_B.Merge_oa[i] = look1_iu16lftf_binlcapw(get_GaCDP_CellVolt_mV( i ),
          ((const uint16_T *)&(CaSOH_CATL203ChrgOCVSOCCellVolt_mV[0])), ((const
          real32_T *)&(CaSOH_CATL203ChrgOCVSOCCellSOC_pct[0])), 29U);
      }
      break;

     case Enum_UDSCapSel_CATL51Ah:
      for (i = 0; i < 112; i++)
      {
        SOH_B.Merge_oa[i] = look1_iu16lftf_binlcapw(get_GaCDP_CellVolt_mV( i ),
          ((const uint16_T *)&(CaSOH_TFE177ChrgOCVSOCCellVolt_mV[0])), ((const
          real32_T *)&(CaSOH_TFE177ChrgOCVSOCCellSOC_pct[0])), 29U);
      }
      break;

     case Enum_UDSCapSel_CATL132Ah:
      for (i = 0; i < 112; i++)
      {
        SOH_B.Merge_oa[i] = look1_iu16lftf_binlcapw(get_GaCDP_CellVolt_mV( i ),
          ((const uint16_T *)&(CaSOH_TFE177ChrgOCVSOCCellVolt_mV[0])), ((const
          real32_T *)&(CaSOH_TFE177ChrgOCVSOCCellSOC_pct[0])), 29U);
      }
      break;

     case Enum_UDSCapSel_XWD75Ah:
      for (i = 0; i < 112; i++)
      {
        SOH_B.Merge_oa[i] = look1_iu16lftf_binlcapw(get_GaCDP_CellVolt_mV( i ),
          ((const uint16_T *)&(CaSOH_XWD75ChrgOCVSOCCellVolt_mV[0])), ((const
          real32_T *)&(CaSOH_XWD75ChrgOCVSOCCellSOC_pct[0])), 29U);
      }
      break;

     case Enum_UDSCapSel_TFE177Ah:
      for (i = 0; i < 112; i++)
      {
        SOH_B.Merge_oa[i] = look1_iu16lftf_binlcapw(get_GaCDP_CellVolt_mV( i ),
          ((const uint16_T *)&(CaSOH_TFE177ChrgOCVSOCCellVolt_mV[0])), ((const
          real32_T *)&(CaSOH_TFE177ChrgOCVSOCCellSOC_pct[0])), 29U);
      }
      break;

     case Enum_UDSCapSel_CATLCTP248Ah:
      for (i = 0; i < 112; i++)
      {
        SOH_B.Merge_oa[i] = look1_iu16lftf_binlcapw(get_GaCDP_CellVolt_mV( i ),
          ((const uint16_T *)&(CaSOH_TFE177ChrgOCVSOCCellVolt_mV[0])), ((const
          real32_T *)&(CaSOH_TFE177ChrgOCVSOCCellSOC_pct[0])), 29U);
      }
      break;
    }

    LbSOH_ShutdownCellState_flg = ((get_GbNVM_ReadMaxCellVoltVld_flg() ==
      ((boolean_T)ASWTYPE_TRUE)) && (get_GbNVM_ReadMinCellVoltVld_flg() ==
      ((boolean_T)ASWTYPE_TRUE)) && ((get_GcCDP_MaxCellVolt_mV() <
      get_EcNVM_MaxCellVolt_mV() - CcSOH_CellVoltMeasTol_mV) &&
      (get_GcCDP_MinCellVolt_mV() < get_EcNVM_MinCellVolt_mV() -
       CcSOH_CellVoltMeasTol_mV)));
    switch ((int32_T)get_GeUDS_CapSel_enum())
    {
     case Enum_UDSCapSel_Default:
      for (i = 0; i < 112; i++)
      {
        SOH_B.Merge_i[i] = look1_iu16lftf_binlcapw(get_GaCDP_CellVolt_mV( i ),
          ((const uint16_T *)&(CaSOH_CATL203DisChrgOCVSOCCellVolt_mV[0])), ((
          const real32_T *)&(CaSOH_CATL203DisChrgOCVSOCCellSOC_pct[0])), 29U);
      }
      break;

     case Enum_UDSCapSel_CATL153Ah:
      for (i = 0; i < 112; i++)
      {
        SOH_B.Merge_i[i] = look1_iu16lftf_binlcapw(get_GaCDP_CellVolt_mV( i ),
          ((const uint16_T *)&(CaSOH_TFE177DisChrgOCVSOCCellVolt_mV[0])), ((
          const real32_T *)&(CaSOH_TFE177DisChrgOCVSOCCellSOC_pct[0])), 29U);
      }
      break;

     case Enum_UDSCapSel_CATL180Ah:
      for (i = 0; i < 112; i++)
      {
        SOH_B.Merge_i[i] = look1_iu16lftf_binlcapw(get_GaCDP_CellVolt_mV( i ),
          ((const uint16_T *)&(CaSOH_TFE177DisChrgOCVSOCCellVolt_mV[0])), ((
          const real32_T *)&(CaSOH_TFE177DisChrgOCVSOCCellSOC_pct[0])), 29U);
      }
      break;

     case Enum_UDSCapSel_CATL177Ah:
      for (i = 0; i < 112; i++)
      {
        SOH_B.Merge_i[i] = look1_iu16lftf_binlcapw(get_GaCDP_CellVolt_mV( i ),
          ((const uint16_T *)&(CaSOH_CATL177DisChrgOCVSOCCellVolt_mV[0])), ((
          const real32_T *)&(CaSOH_CATL177DisChrgOCVSOCCellSOC_pct[0])), 29U);
      }
      break;

     case Enum_UDSCapSel_CATL203Ah:
      for (i = 0; i < 112; i++)
      {
        SOH_B.Merge_i[i] = look1_iu16lftf_binlcapw(get_GaCDP_CellVolt_mV( i ),
          ((const uint16_T *)&(CaSOH_CATL203DisChrgOCVSOCCellVolt_mV[0])), ((
          const real32_T *)&(CaSOH_CATL203DisChrgOCVSOCCellSOC_pct[0])), 29U);
      }
      break;

     case Enum_UDSCapSel_CATL51Ah:
      for (i = 0; i < 112; i++)
      {
        SOH_B.Merge_i[i] = look1_iu16lftf_binlcapw(get_GaCDP_CellVolt_mV( i ),
          ((const uint16_T *)&(CaSOH_TFE177DisChrgOCVSOCCellVolt_mV[0])), ((
          const real32_T *)&(CaSOH_TFE177DisChrgOCVSOCCellSOC_pct[0])), 29U);
      }
      break;

     case Enum_UDSCapSel_CATL132Ah:
      for (i = 0; i < 112; i++)
      {
        SOH_B.Merge_i[i] = look1_iu16lftf_binlcapw(get_GaCDP_CellVolt_mV( i ),
          ((const uint16_T *)&(CaSOH_TFE177DisChrgOCVSOCCellVolt_mV[0])), ((
          const real32_T *)&(CaSOH_TFE177DisChrgOCVSOCCellSOC_pct[0])), 29U);
      }
      break;

     case Enum_UDSCapSel_XWD75Ah:
      for (i = 0; i < 112; i++)
      {
        SOH_B.Merge_i[i] = look1_iu16lftf_binlcapw(get_GaCDP_CellVolt_mV( i ),
          ((const uint16_T *)&(CaSOH_XWD75DisChrgOCVSOCCellVolt_mV[0])), ((const
          real32_T *)&(CaSOH_XWD75DisChrgOCVSOCCellSOC_pct[0])), 29U);
      }
      break;

     case Enum_UDSCapSel_TFE177Ah:
      for (i = 0; i < 112; i++)
      {
        SOH_B.Merge_i[i] = look1_iu16lftf_binlcapw(get_GaCDP_CellVolt_mV( i ),
          ((const uint16_T *)&(CaSOH_TFE177DisChrgOCVSOCCellVolt_mV[0])), ((
          const real32_T *)&(CaSOH_TFE177DisChrgOCVSOCCellSOC_pct[0])), 29U);
      }
      break;

     case Enum_UDSCapSel_CATLCTP248Ah:
      for (i = 0; i < 112; i++)
      {
        SOH_B.Merge_i[i] = look1_iu16lftf_binlcapw(get_GaCDP_CellVolt_mV( i ),
          ((const uint16_T *)&(CaSOH_TFE177DisChrgOCVSOCCellVolt_mV[0])), ((
          const real32_T *)&(CaSOH_TFE177DisChrgOCVSOCCellSOC_pct[0])), 29U);
      }
      break;
    }

    for (i = 0; i < 112; i++)
    {
      if (LbSOH_ShutdownCellState_flg)
      {
        LaSOH_AllCellSOC_pct[i] = SOH_B.Merge_oa[i];
      }
      else
      {
        LaSOH_AllCellSOC_pct[i] = SOH_B.Merge_i[i];
      }

      if (LaSOH_AllCellSOC_pct[i] >= get_EaNVM_AllCellOCVSOC_pct( i ))
      {
        rtb_Switch_fm[i] = LaSOH_AllCellSOC_pct[i] - get_EaNVM_AllCellOCVSOC_pct
          ( i );
      }
      else
      {
        rtb_Switch_fm[i] = get_EaNVM_AllCellOCVSOC_pct( i ) -
          LaSOH_AllCellSOC_pct[i];
      }

      rtb_RelationalOperator_mj[i] = (get_EaNVM_AllCellOCVSOC_pct( i ) >
        CcSOH_SOHCalSOCThrd_pct);
    }

    rtb_LogicalOperator2 = rtb_RelationalOperator_mj[0];
    for (i = 0; i < 111; i++)
    {
      rtb_LogicalOperator2 = (rtb_LogicalOperator2 ||
        rtb_RelationalOperator_mj[i + 1]);
    }

    for (i = 0; i < 112; i++)
    {
      LaSOH_OCVSOHCal_flg[i] = ((rtb_Switch_fm[i] >= CcSOH_SOHCalDiffSOCThrd_pct)
        && rtb_LogicalOperator2);
    }

    for (i = 0; i < 112; i++)
    {
      if (LaSOH_OCVSOHCal_flg[i])
      {
        if (fabsf(rtb_Switch_fm[i]) < 1.0E-6F)
        {
          rtb_Switch4 = 1.0E-6F;
        }
        else
        {
          rtb_Switch4 = rtb_Switch_fm[i];
        }

        rtb_Switch4 = rtb_Divide_m / rtb_Switch4 * (real32_T)SOH_Const100_Numb;
      }
      else
      {
        rtb_Switch4 = get_EaNVM_AllCellCap_Ah( i );
      }

      rtb_Switch_fm[i] = rtb_Switch4;
    }

    rtb_Divide_m = (real32_T)get_GcUDS_BatCap_Ah() * CcSOH_SOHHighThrd_pct;
    for (i = 0; i < 112; i++)
    {
      rtb_RelationalOperator_mj[i] = (rtb_Divide_m >= rtb_Switch_fm[i]);
    }

    rtb_Divide_m = (real32_T)get_GcUDS_BatCap_Ah() * CcSOH_SOHLowThrd_pct;
    for (i = 0; i < 112; i++)
    {
      rtb_Switch4 = rtb_Switch_fm[i];
      if (!(rtb_RelationalOperator_mj[i] && (rtb_Switch_fm[i] >= rtb_Divide_m)))
      {
        rtb_Switch4 = get_EaNVM_AllCellCap_Ah( i );
      }

      rtb_Switch_fm[i] = rtb_Switch4;
    }

    for (i = 0; i < 112; i++)
    {
      set_EaNVM_AllCellCap_Ah( i , rtb_Switch_fm[i]);
    }

    rtb_RelationalOperator_im = false;
    for (s44_iter = 1; s44_iter <= get_GcUDS_CellVoltNum_numb(); s44_iter++)
    {
      LbSOH_OCVSOHCal_flg = (LaSOH_OCVSOHCal_flg[s44_iter - 1] ||
        rtb_RelationalOperator_im);
      rtb_RelationalOperator_im = LbSOH_OCVSOHCal_flg;
    }

    if (LbSOH_OCVSOHCal_flg)
    {
      for (i = 0; i < 112; i++)
      {
        set_EaNVM_AllCellOCVSOC_pct( i , LaSOH_AllCellSOC_pct[i]);
      }

      set_EcNVM_CellAbsvCap_Ah((real32_T)SOH_Const0_Numb);
      set_EcNVM_NVMOCVCorrdSumTi_ms(SOH_Const0_Numb);
      set_EcNVM_CellChrgDisCap_Ah((real32_T)SOH_Const0_Numb);
    }

    if (!rtb_LogicalOperator2)
    {
      for (i = 0; i < 112; i++)
      {
        set_EaNVM_AllCellOCVSOC_pct( i , LaSOH_AllCellSOC_pct[i]);
      }

      set_EcNVM_NVMOCVCorrdSign_numb(SOH_Const165_Numb);
    }
  }
  else
  {
    if (SOH_DW.NVMOCVSOH_Calculation_MODE)
    {
      SOH_DW.NVMOCVSOH_Calculation_MODE = false;
    }
  }

  if (get_GcRTC_PackUsageTi_Day() >= CcSOH_PackUsageTi_Day)
  {
    rtb_Divide_m = fmaxf(get_EcNVM_PackSOH2_pct(), get_GcSOH_PackSOH1_pct());
  }
  else
  {
    rtb_Divide_m = fmaxf(fminf(get_GcSOH_PackSOH1_pct(), get_EcNVM_PackSOH2_pct()),
                         get_EcNVM_PackSOH3_pct());
  }

  if (SOH_DW.StateName_d != 0)
  {
    rtb_Switch4 = rtb_Divide_m;
  }
  else
  {
    rtb_Switch4 = SOH_DW.StateName_f;
  }

  SOH_DW.StateName_d = 0U;
  SOH_DW.StateName_f = rtb_Divide_m;
  if (CbSOH_PackSOHOvrSwt_flg)
  {
    set_GcSOH_PackSOH_pct(CcSOH_PackSOHOvr_pct);
  }
  else
  {
    rtb_Divide_m = fminf(rtb_Divide_m, rtb_Switch4);
    if (CcSOH_SOHHighThrd_pct < rtb_Divide_m)
    {
      rtb_Divide_m = CcSOH_SOHHighThrd_pct;
    }

    if (rtb_Divide_m > CcSOH_SOHLowThrd_pct)
    {
      set_GcSOH_PackSOH_pct(rtb_Divide_m);
    }
    else
    {
      set_GcSOH_PackSOH_pct(CcSOH_SOHLowThrd_pct);
    }
  }

  if (CbSOH_CurrBatCapOvrSwt_flg)
  {
    set_GcSOH_CurrBatCap_Ah(CcSOH_CurrBatCapOvr_Ah);
  }
  else
  {
    set_GcSOH_CurrBatCap_Ah((real32_T)get_GcUDS_BatCap_Ah() *
      get_GcSOH_PackSOH_pct());
  }

  rtb_Divide_m = fminf(LcSOH_MinCellCap_Ah, get_GcSOH_CurrBatCap_Ah());
  if (rtb_Divide_m < (real32_T)get_GcUDS_BatCap_Ah() * CcSOH_SOHAlarmThrd_pct)
  {
    rtb_Switch1_f = Enum_SOHCapFltState_Alarm;
  }
  else if (rtb_Divide_m < (real32_T)get_GcUDS_BatCap_Ah() *
           CcSOH_SOHWarningThrd_pct)
  {
    rtb_Switch1_f = Enum_SOHCapFltState_Warning;
  }
  else
  {
    rtb_Switch1_f = Enum_SOHCapFltState_Normal;
  }

  if (CbSOH_CapFltAlarmOvrSwt_flg)
  {
    set_GbSOH_CapFltAlarm_flg(CbSOH_CapFltAlarmOvr_flg);
  }
  else
  {
    set_GbSOH_CapFltAlarm_flg((Enum_SOHCapFltState_Alarm == rtb_Switch1_f));
  }

  if (CbSOH_CapFltWarnOvrSwt_flg)
  {
    set_GbSOH_CapFltWarn_flg(CbSOH_CapFltWarnOvr_flg);
  }
  else
  {
    set_GbSOH_CapFltWarn_flg((Enum_SOHCapFltState_Warning == rtb_Switch1_f));
  }

  rtb_LogicalOperator2 = !SOH_DW.StateName_p0;
  if (rtb_LogicalOperator2 || (SOH_DW.FixPtUnitDelay2_DSTATE != 0))
  {
    rtb_Switch2_g = 0U;
  }
  else
  {
    rtb_Switch2_g = SOH_DW.FixPtUnitDelay1_DSTATE;
  }

  LbSOH_SOHTableEnable_flg = (rtb_Switch2_g >= CcSOH_SOH2RunCycleTi_ms);
  if (rtb_LogicalOperator2)
  {
    SOH_DW.FixPtUnitDelay1_DSTATE = 0U;
  }
  else
  {
    if (LbSOH_SOHTableEnable_flg)
    {
      rtb_LogicalOperator2_0 = 0U;
    }
    else
    {
      rtb_LogicalOperator2_0 = SOH_Runtime10_ms;
    }

    SOH_DW.FixPtUnitDelay1_DSTATE = rtb_LogicalOperator2_0 + rtb_Switch2_g;
  }

  SOH_DW.FixPtUnitDelay2_DSTATE = 0U;
  if (LbSOH_SOHTableEnable_flg)
  {
    if (get_GbCDP_AllCellTempVld_flg() && (get_GcRTC_CalenderLife_Day() >
         CcSOH_SOH2EnaTiThrd_Day))
    {
      switch ((int32_T)get_GeUDS_CapSel_enum())
      {
       case Enum_UDSCapSel_Default:
        SOH_SwitchCaseActionSubsystem(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_a);
        SOH_SwitchCaseActionSubsystem_l(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_f);
        SOH_SwitchCaseActionSubsystem_o(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_o);
        SO_SwitchCaseActionSubsystem_ob(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_j);
        break;

       case Enum_UDSCapSel_CATL153Ah:
        SOH_SwitchCaseActionSubsystem1(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_a);
        SO_SwitchCaseActionSubsystem1_k(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_f);
        SO_SwitchCaseActionSubsystem1_o(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_o);
        SO_SwitchCaseActionSubsystem1_e(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_j);
        break;

       case Enum_UDSCapSel_CATL180Ah:
        SOH_SwitchCaseActionSubsystem1(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_a);
        SO_SwitchCaseActionSubsystem1_k(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_f);
        SO_SwitchCaseActionSubsystem1_o(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_o);
        SO_SwitchCaseActionSubsystem1_e(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_j);
        break;

       case Enum_UDSCapSel_CATL177Ah:
        SOH_SwitchCaseActionSubsystem(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_a);
        SOH_SwitchCaseActionSubsystem_l(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_f);
        SOH_SwitchCaseActionSubsystem_o(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_o);
        SO_SwitchCaseActionSubsystem_ob(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_j);
        break;

       case Enum_UDSCapSel_CATL203Ah:
        SOH_B.Merge_a = look1_iu32lftf_binlcapw(get_GcRTC_CalenderLife_Day(), ((
          const uint32_T *)&(CaSOH_CATL203CalenderDayTable1_Day[0])), ((const
          real32_T *)&(CaSOH_CalenderSOH_pct[0])), 39U);
        SOH_B.Merge_f = look1_iu32lftf_binlcapw(get_GcRTC_CalenderLife_Day(), ((
          const uint32_T *)&(CaSOH_CATL203CalenderDayTable2_Day[0])), ((const
          real32_T *)&(CaSOH_CalenderSOH_pct[0])), 39U);
        SOH_B.Merge_o = look1_iu32lftf_binlcapw(get_GcRTC_CalenderLife_Day(), ((
          const uint32_T *)&(CaSOH_CATL203CalenderDayTable3_Day[0])), ((const
          real32_T *)&(CaSOH_CalenderSOH_pct[0])), 39U);
        SOH_B.Merge_j = look1_iu32lftf_binlcapw(get_GcRTC_CalenderLife_Day(), ((
          const uint32_T *)&(CaSOH_CATL203CalenderDayTable4_Day[0])), ((const
          real32_T *)&(CaSOH_CalenderSOH_pct[0])), 39U);
        break;

       case Enum_UDSCapSel_CATL51Ah:
        SOH_SwitchCaseActionSubsystem1(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_a);
        SO_SwitchCaseActionSubsystem1_k(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_f);
        SO_SwitchCaseActionSubsystem1_o(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_o);
        SO_SwitchCaseActionSubsystem1_e(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_j);
        break;

       case Enum_UDSCapSel_CATL132Ah:
        SOH_SwitchCaseActionSubsystem1(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_a);
        SO_SwitchCaseActionSubsystem1_k(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_f);
        SO_SwitchCaseActionSubsystem1_o(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_o);
        SO_SwitchCaseActionSubsystem1_e(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_j);
        break;

       case Enum_UDSCapSel_XWD75Ah:
        SOH_B.Merge_a = look1_iu32lftf_binlcapw(get_GcRTC_CalenderLife_Day(), ((
          const uint32_T *)&(CaSOH_XWD75CalenderDayTable1_Day[0])), ((const
          real32_T *)&(CaSOH_CalenderSOH_pct[0])), 39U);
        SOH_B.Merge_f = look1_iu32lftf_binlcapw(get_GcRTC_CalenderLife_Day(), ((
          const uint32_T *)&(CaSOH_XWD75CalenderDayTable2_Day[0])), ((const
          real32_T *)&(CaSOH_CalenderSOH_pct[0])), 39U);
        SOH_B.Merge_o = look1_iu32lftf_binlcapw(get_GcRTC_CalenderLife_Day(), ((
          const uint32_T *)&(CaSOH_XWD75CalenderDayTable3_Day[0])), ((const
          real32_T *)&(CaSOH_CalenderSOH_pct[0])), 39U);
        SOH_B.Merge_j = look1_iu32lftf_binlcapw(get_GcRTC_CalenderLife_Day(), ((
          const uint32_T *)&(CaSOH_XWD75CalenderDayTable4_Day[0])), ((const
          real32_T *)&(CaSOH_CalenderSOH_pct[0])), 39U);
        break;

       case Enum_UDSCapSel_TFE177Ah:
        SOH_SwitchCaseActionSubsystem1(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_a);
        SO_SwitchCaseActionSubsystem1_k(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_f);
        SO_SwitchCaseActionSubsystem1_o(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_o);
        SO_SwitchCaseActionSubsystem1_e(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_j);
        break;

       case Enum_UDSCapSel_CATLCTP248Ah:
        SOH_SwitchCaseActionSubsystem1(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_a);
        SO_SwitchCaseActionSubsystem1_k(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_f);
        SO_SwitchCaseActionSubsystem1_o(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_o);
        SO_SwitchCaseActionSubsystem1_e(get_GcRTC_CalenderLife_Day(),
          &SOH_B.Merge_j);
        break;
      }

      if (get_GcCDP_AvgCellTemp_C() < CcSOH_SOH2TempThrd1_C)
      {
        LcSOH_CalenderLifeLoss_pct = SOH_B.Merge_a;
      }
      else if (get_GcCDP_AvgCellTemp_C() < CcSOH_SOH2TempThrd2_C)
      {
        LcSOH_CalenderLifeLoss_pct = SOH_B.Merge_f;
      }
      else if (get_GcCDP_AvgCellTemp_C() < CcSOH_SOH2TempThrd3_C)
      {
        LcSOH_CalenderLifeLoss_pct = SOH_B.Merge_o;
      }
      else
      {
        LcSOH_CalenderLifeLoss_pct = SOH_B.Merge_j;
      }
    }

    rtb_Divide_m = get_EcNVM_TotalChrgCap_Ah() + get_EcNVM_TotalDischrgCap_Ah();
    if (get_GbCDP_AllCellTempVld_flg() && (rtb_Divide_m > CcSOH_SOH2EnaThrd_Ah))
    {
      switch ((int32_T)get_GeUDS_CapSel_enum())
      {
       case Enum_UDSCapSel_Default:
        SOH_SwitchCaseActionSubsystem_d(rtb_Divide_m, &SOH_B.Merge_h);
        SOH_SwitchCaseActionSubsystem_p(rtb_Divide_m, &SOH_B.Merge_p);
        SOH_SwitchCaseActionSubsystem_m(rtb_Divide_m, &SOH_B.Merge_n);
        SOH_SwitchCaseActionSubsystem_j(rtb_Divide_m, &SOH_B.Merge);
        break;

       case Enum_UDSCapSel_CATL153Ah:
        SOH_SwitchCaseActionSubsystem_d(rtb_Divide_m, &SOH_B.Merge_h);
        SOH_SwitchCaseActionSubsystem_p(rtb_Divide_m, &SOH_B.Merge_p);
        SOH_SwitchCaseActionSubsystem_m(rtb_Divide_m, &SOH_B.Merge_n);
        SOH_SwitchCaseActionSubsystem_j(rtb_Divide_m, &SOH_B.Merge);
        break;

       case Enum_UDSCapSel_CATL180Ah:
        SOH_SwitchCaseActionSubsystem_d(rtb_Divide_m, &SOH_B.Merge_h);
        SOH_SwitchCaseActionSubsystem_p(rtb_Divide_m, &SOH_B.Merge_p);
        SOH_SwitchCaseActionSubsystem_m(rtb_Divide_m, &SOH_B.Merge_n);
        SOH_SwitchCaseActionSubsystem_j(rtb_Divide_m, &SOH_B.Merge);
        break;

       case Enum_UDSCapSel_CATL177Ah:
        SOH_SwitchCaseActionSubsystem_d(rtb_Divide_m, &SOH_B.Merge_h);
        SOH_SwitchCaseActionSubsystem_p(rtb_Divide_m, &SOH_B.Merge_p);
        SOH_SwitchCaseActionSubsystem_m(rtb_Divide_m, &SOH_B.Merge_n);
        SOH_SwitchCaseActionSubsystem_j(rtb_Divide_m, &SOH_B.Merge);
        break;

       case Enum_UDSCapSel_CATL203Ah:
        SOH_B.Merge_h = look1_iflf_binlcapw(rtb_Divide_m, ((const real32_T *)
          &(CaSOH_CATL203CycleCapAhTable1_Ah[0])), ((const real32_T *)
          &(CaSOH_CycleSOH_pct[0])), 39U);
        SOH_B.Merge_p = look1_iflf_binlcapw(rtb_Divide_m, ((const real32_T *)
          &(CaSOH_CATL203CycleCapAhTable2_Ah[0])), ((const real32_T *)
          &(CaSOH_CycleSOH_pct[0])), 39U);
        SOH_B.Merge_n = look1_iflf_binlcapw(rtb_Divide_m, ((const real32_T *)
          &(CaSOH_CATL203CycleCapAhTable3_Ah[0])), ((const real32_T *)
          &(CaSOH_CycleSOH_pct[0])), 39U);
        SOH_B.Merge = look1_iflf_binlcapw(rtb_Divide_m, ((const real32_T *)
          &(CaSOH_CATL203CycleCapAhTable4_Ah[0])), ((const real32_T *)
          &(CaSOH_CycleSOH_pct[0])), 39U);
        break;

       case Enum_UDSCapSel_CATL51Ah:
        SOH_SwitchCaseActionSubsystem_d(rtb_Divide_m, &SOH_B.Merge_h);
        SOH_SwitchCaseActionSubsystem_p(rtb_Divide_m, &SOH_B.Merge_p);
        SOH_SwitchCaseActionSubsystem_m(rtb_Divide_m, &SOH_B.Merge_n);
        SOH_SwitchCaseActionSubsystem_j(rtb_Divide_m, &SOH_B.Merge);
        break;

       case Enum_UDSCapSel_CATL132Ah:
        SOH_SwitchCaseActionSubsystem_d(rtb_Divide_m, &SOH_B.Merge_h);
        SOH_SwitchCaseActionSubsystem_p(rtb_Divide_m, &SOH_B.Merge_p);
        SOH_SwitchCaseActionSubsystem_m(rtb_Divide_m, &SOH_B.Merge_n);
        SOH_SwitchCaseActionSubsystem_j(rtb_Divide_m, &SOH_B.Merge);
        break;

       case Enum_UDSCapSel_XWD75Ah:
        SOH_B.Merge_h = look1_iflf_binlcapw(rtb_Divide_m, ((const real32_T *)
          &(CaSOH_XWD75CycleCapAhTable1_Ah[0])), ((const real32_T *)
          &(CaSOH_CycleSOH_pct[0])), 39U);
        SOH_B.Merge_p = look1_iflf_binlcapw(rtb_Divide_m, ((const real32_T *)
          &(CaSOH_XWD75CycleCapAhTable2_Ah[0])), ((const real32_T *)
          &(CaSOH_CycleSOH_pct[0])), 39U);
        SOH_B.Merge_n = look1_iflf_binlcapw(rtb_Divide_m, ((const real32_T *)
          &(CaSOH_XWD75CycleCapAhTable3_Ah[0])), ((const real32_T *)
          &(CaSOH_CycleSOH_pct[0])), 39U);
        SOH_B.Merge = look1_iflf_binlcapw(rtb_Divide_m, ((const real32_T *)
          &(CaSOH_XWD75CycleCapAhTable4_Ah[0])), ((const real32_T *)
          &(CaSOH_CycleSOH_pct[0])), 39U);
        break;

       case Enum_UDSCapSel_TFE177Ah:
        SOH_B.Merge_h = look1_iflf_binlcapw(rtb_Divide_m, ((const real32_T *)
          &(CaSOH_TFE177CycleCapAhTable1_Ah[0])), ((const real32_T *)
          &(CaSOH_TFE177CycleSOH_pct[0])), 18U);
        SOH_B.Merge_p = look1_iflf_binlcapw(rtb_Divide_m, ((const real32_T *)
          &(CaSOH_TFE177CycleCapAhTable2_Ah[0])), ((const real32_T *)
          &(CaSOH_TFE177CycleSOH_pct[0])), 18U);
        SOH_B.Merge_n = look1_iflf_binlcapw(rtb_Divide_m, ((const real32_T *)
          &(CaSOH_TFE177CycleCapAhTable3_Ah[0])), ((const real32_T *)
          &(CaSOH_TFE177CycleSOH_pct[0])), 18U);
        SOH_B.Merge = look1_iflf_binlcapw(rtb_Divide_m, ((const real32_T *)
          &(CaSOH_TFE177CycleCapAhTable4_Ah[0])), ((const real32_T *)
          &(CaSOH_TFE177CycleSOH_pct[0])), 18U);
        break;

       case Enum_UDSCapSel_CATLCTP248Ah:
        SOH_SwitchCaseActionSubsystem_d(rtb_Divide_m, &SOH_B.Merge_h);
        SOH_SwitchCaseActionSubsystem_p(rtb_Divide_m, &SOH_B.Merge_p);
        SOH_SwitchCaseActionSubsystem_m(rtb_Divide_m, &SOH_B.Merge_n);
        SOH_SwitchCaseActionSubsystem_j(rtb_Divide_m, &SOH_B.Merge);
        break;
      }

      if (get_GcCDP_AvgCellTemp_C() < CcSOH_SOH2TempThrd1_C)
      {
        LcSOH_CycleLifeLoss_pct = SOH_B.Merge_h;
      }
      else if (get_GcCDP_AvgCellTemp_C() < CcSOH_SOH2TempThrd2_C)
      {
        LcSOH_CycleLifeLoss_pct = SOH_B.Merge_p;
      }
      else if (get_GcCDP_AvgCellTemp_C() < CcSOH_SOH2TempThrd3_C)
      {
        LcSOH_CycleLifeLoss_pct = SOH_B.Merge_n;
      }
      else
      {
        LcSOH_CycleLifeLoss_pct = SOH_B.Merge;
      }
    }

    if (CbSOH_PackSOH2OvrSwt_flg)
    {
      set_GcSOH_PackSOH2_pct(CcSOH_PackSOH2Ovr_pct);
    }
    else
    {
      set_GcSOH_PackSOH2_pct((SOH_Const1_Numb - LcSOH_CalenderLifeLoss_pct) -
        LcSOH_CycleLifeLoss_pct);
    }

    set_EcNVM_PackSOH2_pct(get_GcSOH_PackSOH2_pct());
    if (get_GcRTC_PackUsageTi_Day() > CcSOH_SOH2EnaTiThrd_Day)
    {
      switch ((int32_T)get_GeUDS_CapSel_enum())
      {
       case Enum_UDSCapSel_Default:
        SO_SwitchCaseActionSubsystem_fi(get_GcRTC_PackUsageTi_Day(), ((real32_T *)
          &(LcSOH_QAUsageLoss_pct)));
        break;

       case Enum_UDSCapSel_CATL153Ah:
        SO_SwitchCaseActionSubsystem_fi(get_GcRTC_PackUsageTi_Day(), ((real32_T *)
          &(LcSOH_QAUsageLoss_pct)));
        break;

       case Enum_UDSCapSel_CATL180Ah:
        SO_SwitchCaseActionSubsystem_fi(get_GcRTC_PackUsageTi_Day(), ((real32_T *)
          &(LcSOH_QAUsageLoss_pct)));
        break;

       case Enum_UDSCapSel_CATL177Ah:
        SO_SwitchCaseActionSubsystem_fi(get_GcRTC_PackUsageTi_Day(), ((real32_T *)
          &(LcSOH_QAUsageLoss_pct)));
        break;

       case Enum_UDSCapSel_CATL203Ah:
        LcSOH_QAUsageLoss_pct = look1_iu32lftf_binlcapw
          (get_GcRTC_PackUsageTi_Day(), ((const uint32_T *)
            &(CaSOH_CATL203QAUsageTable_Day[0])), ((const real32_T *)
            &(CaSOH_QAUsageLossSOH_pct[0])), 39U);
        break;

       case Enum_UDSCapSel_CATL51Ah:
        SO_SwitchCaseActionSubsystem_fi(get_GcRTC_PackUsageTi_Day(), ((real32_T *)
          &(LcSOH_QAUsageLoss_pct)));
        break;

       case Enum_UDSCapSel_CATL132Ah:
        SO_SwitchCaseActionSubsystem_fi(get_GcRTC_PackUsageTi_Day(), ((real32_T *)
          &(LcSOH_QAUsageLoss_pct)));
        break;

       case Enum_UDSCapSel_XWD75Ah:
        LcSOH_QAUsageLoss_pct = look1_iu32lftf_binlcapw
          (get_GcRTC_PackUsageTi_Day(), ((const uint32_T *)
            &(CaSOH_XWD75QAUsageTable_Day[0])), ((const real32_T *)
            &(CaSOH_QAUsageLossSOH_pct[0])), 39U);
        break;

       case Enum_UDSCapSel_TFE177Ah:
        LcSOH_QAUsageLoss_pct = look1_iu32lftf_binlcapw
          (get_GcRTC_PackUsageTi_Day(), ((const uint32_T *)
            &(CaSOH_TFE177QAUsageTable_Day[0])), ((const real32_T *)
            &(CaSOH_QAUsageLossSOH_pct[0])), 39U);
        break;

       case Enum_UDSCapSel_CATLCTP248Ah:
        SO_SwitchCaseActionSubsystem_fi(get_GcRTC_PackUsageTi_Day(), ((real32_T *)
          &(LcSOH_QAUsageLoss_pct)));
        break;
      }
    }

    if (rtb_Divide_m > CcSOH_SOH3EnaThrd_Ah)
    {
      switch ((int32_T)get_GeUDS_CapSel_enum())
      {
       case Enum_UDSCapSel_Default:
        SOH_SwitchCaseActionSubsystem_f(rtb_Divide_m, ((real32_T *)
          &(LcSOH_QAOdoLoss_pct)));
        break;

       case Enum_UDSCapSel_CATL153Ah:
        SOH_SwitchCaseActionSubsystem_f(rtb_Divide_m, ((real32_T *)
          &(LcSOH_QAOdoLoss_pct)));
        break;

       case Enum_UDSCapSel_CATL180Ah:
        SOH_SwitchCaseActionSubsystem_f(rtb_Divide_m, ((real32_T *)
          &(LcSOH_QAOdoLoss_pct)));
        break;

       case Enum_UDSCapSel_CATL177Ah:
        SOH_SwitchCaseActionSubsystem_f(rtb_Divide_m, ((real32_T *)
          &(LcSOH_QAOdoLoss_pct)));
        break;

       case Enum_UDSCapSel_CATL203Ah:
        LcSOH_QAOdoLoss_pct = look1_iflf_binlcapw(rtb_Divide_m, ((const real32_T
          *)&(CaSOH_CATL203QACapAhTable_Ah[0])), ((const real32_T *)
          &(CaSOH_QAOdoLossSOH_pct[0])), 39U);
        break;

       case Enum_UDSCapSel_CATL51Ah:
        SOH_SwitchCaseActionSubsystem_f(rtb_Divide_m, ((real32_T *)
          &(LcSOH_QAOdoLoss_pct)));
        break;

       case Enum_UDSCapSel_CATL132Ah:
        SOH_SwitchCaseActionSubsystem_f(rtb_Divide_m, ((real32_T *)
          &(LcSOH_QAOdoLoss_pct)));
        break;

       case Enum_UDSCapSel_XWD75Ah:
        LcSOH_QAOdoLoss_pct = look1_iflf_binlcapw(rtb_Divide_m, ((const real32_T
          *)&(CaSOH_XWD75QACapAhTable_Ah[0])), ((const real32_T *)
          &(CaSOH_QAOdoLossSOH_pct[0])), 39U);
        break;

       case Enum_UDSCapSel_TFE177Ah:
        LcSOH_QAOdoLoss_pct = look1_iflf_binlcapw(rtb_Divide_m, ((const real32_T
          *)&(CaSOH_TFE177QACapAhTable_Ah[0])), ((const real32_T *)
          &(CaSOH_QAOdoLossSOH_pct[0])), 39U);
        break;

       case Enum_UDSCapSel_CATLCTP248Ah:
        SOH_SwitchCaseActionSubsystem_f(rtb_Divide_m, ((real32_T *)
          &(LcSOH_QAOdoLoss_pct)));
        break;
      }
    }

    LcSOH_QALoss_pct = fmaxf(LcSOH_QAUsageLoss_pct, LcSOH_QAOdoLoss_pct);
    if (CbSOH_PackSOH3OvrSwt_flg)
    {
      set_GcSOH_PackSOH3_pct(CcSOH_PackSOH3Ovr_pct);
    }
    else
    {
      set_GcSOH_PackSOH3_pct(SOH_Const1_Numb - LcSOH_QALoss_pct);
    }

    set_EcNVM_PackSOH3_pct(get_GcSOH_PackSOH3_pct());
  }

  SOH_DW.StateName_li = ((boolean_T)ASWTYPE_FALSE);
  SOH_DW.StateName_b = rtb_RelationalOperator_cp;
  SOH_DW.StateName_p0 = !LbSOH_SOHTableEnable_flg;
}

/* Model initialize function */
void SOH_initialize(void)
{
  SOH_DW.StateName_li = ((boolean_T)ASWTYPE_TRUE);
  SOH_DW.StateName_p0 = ((boolean_T)ASWTYPE_TRUE);
  SOH_DW.FixPtUnitDelay2_DSTATE_f = 1U;
  SOH_DW.StateName_l = 1U;
  SOH_DW.FixPtUnitDelay2_DSTATE_d = 1U;
  SOH_DW.StateName_d = 1U;
  SOH_DW.FixPtUnitDelay2_DSTATE = 1U;
}

/*
 * File trailer for generated code.
 *
 * [EOF]
 */
