/*
 * File: DCS.c
 *
 * Code generated for Simulink model 'DCS'.
 *
 * Company                        : AIWAYS
 * Author                         : lvkh
 * Model version                  : 'M108C106'
 * Simulink Coder version         : 8.13 (R2017b) 24-Jul-2017
 * C/C++ source code generated on : Thu Jun 16 09:04:31 2022
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: Infineon->TriCore
 * Code generation objectives:
 *    1. MISRA C:2012 guidelines
 *    2. Safety precaution
 * Validation result: Not run
 */

#include "DCS.h"
#include "DCS_private.h"

/* Block signals (auto storage) */
B_DCS_T DCS_B;

/* Block states (auto storage) */
DW_DCS_T DCS_DW;

/* External outputs (root outports fed by signals with auto storage) */
ExtY_DCS_T DCS_Y;

/*
 * Output and update for action system:
 *    '<S19>/Switch Case Action Subsystem'
 *    '<S19>/Switch Case Action Subsystem1'
 */
void DCS_SwitchCaseActionSubsystem(real32_T *rty_Case_Output)
{
  *rty_Case_Output = CcDCS_CATL153Ah2817MaxCurPermit_A;
}

/*
 * Output and update for action system:
 *    '<S20>/Switch Case Action Subsystem'
 *    '<S20>/Switch Case Action Subsystem1'
 */
void DCS_SwitchCaseActionSubsystem_j(real32_T *rty_Case_Output)
{
  *rty_Case_Output = CcDCS_CATL153Ah2819MaxVoltPermit_V;
}

/*
 * Output and update for action system:
 *    '<S70>/Switch Case Action Subsystem'
 *    '<S70>/Switch Case Action Subsystem1'
 */
void DCS_SwitchCaseActionSubsystem_h(real32_T *rty_Case_Output)
{
  *rty_Case_Output = CcDCS_CATL153Ah2567BattCap_Ah;
}

/*
 * Output and update for action system:
 *    '<S71>/Switch Case Action Subsystem'
 *    '<S71>/Switch Case Action Subsystem1'
 */
void DC_SwitchCaseActionSubsystem_j2(real32_T *rty_Case_Output)
{
  *rty_Case_Output = CcDCS_CATL153Ah2568BattVolt_V;
}

/* Model step function */
void DCS_BST_10ms(void)
{
  boolean_T rtb_LogicalOperator2;
  boolean_T rtb_RelationalOperator;
  boolean_T rtb_RelationalOperator1;
  uint8_T rtb_Switch1;
  uint8_T rtb_Switch1_i_idx_3;
  rtb_LogicalOperator2 = (DCS_DW.StateName || ((get_GbDCC_BSTMsgCmd_flg() ==
    ((boolean_T)ASWTYPE_FALSE)) && get_GbGDP_CSTRecOnce_flg()));
  if (CbDCS_3511ChrgrStopOvrSwt_flg)
  {
    set_GeDCS_3511ChrgrStop_enum(CeDCS_3511ChrgrStopOvr_enum);
  }
  else if (rtb_LogicalOperator2)
  {
    set_GeDCS_3511ChrgrStop_enum(DCS_ONE_NUMB);
  }
  else
  {
    set_GeDCS_3511ChrgrStop_enum(DCS_ZERO_NUMB);
  }

  if (get_GbDCC_DCChrgFinish_flg())
  {
    rtb_Switch1 = DCS_ONE_NUMB;
  }
  else
  {
    rtb_Switch1 = DCS_ZERO_NUMB;
  }

  if (CbDCS_3511ReachCellVoltOvrSwt_flg)
  {
    set_GeDCS_3511ReachCellVolt_enum(CeDCS_3511ReachCellVoltOvr_enum);
  }
  else
  {
    set_GeDCS_3511ReachCellVolt_enum(rtb_Switch1);
  }

  if (CbDCS_3511ReachSOCOvrSwt_flg)
  {
    set_GeDCS_3511ReachSOC_enum(CeDCS_3511ReachSOCOvr_enum);
  }
  else
  {
    set_GeDCS_3511ReachSOC_enum(rtb_Switch1);
  }

  if (CbDCS_3511ReachPackVoltOvrSwt_flg)
  {
    set_GeDCS_3511ReachPackVolt_enum(CeDCS_3511ReachPackVoltOvr_enum);
  }
  else
  {
    set_GeDCS_3511ReachPackVolt_enum(DCS_ZERO_NUMB);
  }

  rtb_RelationalOperator = (get_GeISO_ResFltLvl_enum() == (int32_T)
    Enum_ISOHVIsoFltLevel_FltLevel3);
  rtb_RelationalOperator1 = (get_GeLDP_DCPlugTempState_enum() == (int32_T)
    Enum_LDPDCChrgPlugTempState_FltLevel3);
  if (((boolean_T)ASWTYPE_FALSE))
  {
    rtb_Switch1 = DCS_ONE_NUMB;
    rtb_Switch1_i_idx_3 = DCS_ONE_NUMB;
  }
  else
  {
    rtb_Switch1 = DCS_ZERO_NUMB;
    rtb_Switch1_i_idx_3 = DCS_ZERO_NUMB;
  }

  if (CbDCS_3512BMSCompOverTempOvrSwt_flg)
  {
    set_GeDCS_3512BMSCompOverTemp_enum(CeDCS_3512BMSCompOverTempOvr_enum);
  }
  else
  {
    set_GeDCS_3512BMSCompOverTemp_enum(rtb_Switch1);
  }

  if (CbDCS_3512ChrgContFltOvrSwt_flg)
  {
    set_GeDCS_3512ChrgContFlt_enum(CeDCS_3512ChrgContFltOvr_enum);
  }
  else
  {
    set_GeDCS_3512ChrgContFlt_enum(rtb_Switch1_i_idx_3);
  }

  if (get_GbCTD_DCPosCloseFlt_flg() || get_GbCTD_DCPosOpenFlt_flg())
  {
    rtb_Switch1 = DCS_ONE_NUMB;
  }
  else
  {
    rtb_Switch1 = DCS_ZERO_NUMB;
  }

  if (CbDCS_3512HVRlyFltOvrSwt_flg)
  {
    set_GeDCS_3512HVRlyFlt_enum(CeDCS_3512HVRlyFltOvr_enum);
  }
  else
  {
    set_GeDCS_3512HVRlyFlt_enum(rtb_Switch1);
  }

  if (CbDCS_3512IsoFltOvrSwt_flg)
  {
    set_GeDCS_3512IsoFlt_enum(CeDCS_3512IsoFltOvr_enum);
  }
  else if (rtb_RelationalOperator)
  {
    set_GeDCS_3512IsoFlt_enum(DCS_ONE_NUMB);
  }
  else
  {
    set_GeDCS_3512IsoFlt_enum(DCS_ZERO_NUMB);
  }

  if (CbDCS_3512CC2VoltFltOvrSwt_flg)
  {
    set_GeDCS_3512CC2VoltFlt_enum(CeDCS_3512CC2VoltFltOvr_enum);
  }
  else if (get_GbLDP_CC2STG_flg() || get_GbLDP_CC2VoltRaty_flg())
  {
    set_GeDCS_3512CC2VoltFlt_enum(DCS_ONE_NUMB);
  }
  else
  {
    set_GeDCS_3512CC2VoltFlt_enum(DCS_ZERO_NUMB);
  }

  if (CbDCS_3512OtherOvrSwt_flg)
  {
    set_GeDCS_3512Other_enum(CeDCS_3512OtherOvr_enum);
  }
  else
  {
    rtb_RelationalOperator = (rtb_RelationalOperator || rtb_RelationalOperator1);
    rtb_RelationalOperator = (rtb_RelationalOperator || ((boolean_T)
      ASWTYPE_FALSE));
    rtb_RelationalOperator = (rtb_RelationalOperator || ((boolean_T)
      ASWTYPE_FALSE));
    rtb_RelationalOperator = (rtb_RelationalOperator ||
      get_GbISP_TFCellTempHiFltLv2_flg());
    if ((rtb_Switch1 == DCS_ZERO_NUMB) && (rtb_RelationalOperator == ((boolean_T)
          ASWTYPE_FALSE)) && (get_GcFTC_FltLevel_numb() >= CeDCS_FltLevel_enum) &&
        (get_GeDCS_3512CC2VoltFlt_enum() == DCS_ZERO_NUMB))
    {
      set_GeDCS_3512Other_enum(DCS_ONE_NUMB);
    }
    else
    {
      set_GeDCS_3512Other_enum(DCS_ZERO_NUMB);
    }
  }

  if (CbDCS_3512OutContOverTempOvrSwt_flg)
  {
    set_GeDCS_3512OutContOverTemp_enum(CeDCS_3512OutContOverTempOvr_enum);
  }
  else if (rtb_RelationalOperator1)
  {
    set_GeDCS_3512OutContOverTemp_enum(DCS_ONE_NUMB);
  }
  else
  {
    set_GeDCS_3512OutContOverTemp_enum(DCS_ZERO_NUMB);
  }

  if (CbDCS_3512TempFltOvrSwt_flg)
  {
    set_GeDCS_3512TempFlt_enum(CeDCS_3512TempFltOvr_enum);
  }
  else if (get_GbISP_TFCellTempHiFltLv2_flg())
  {
    set_GeDCS_3512TempFlt_enum(DCS_ONE_NUMB);
  }
  else
  {
    set_GeDCS_3512TempFlt_enum(DCS_ZERO_NUMB);
  }

  if (CbDCS_3513CurrFltOvrSwt_flg)
  {
    set_GeDCS_3513CurrFlt_enum(CeDCS_3513CurrFltOvr_enum);
  }
  else if ((get_GeSOP_ChrgPwrState_enum() == (int32_T)
            Enum_SOPChrgPwrState_FltLevel3) || get_GbDCC_DCCrntUnctrolFlt_flg())
  {
    set_GeDCS_3513CurrFlt_enum(DCS_ONE_NUMB);
  }
  else
  {
    set_GeDCS_3513CurrFlt_enum(DCS_ZERO_NUMB);
  }

  if (CbDCS_3513VoltFltOvrSwt_flg)
  {
    set_GeDCS_3513VoltFlt_enum(CeDCS_3513VoltFltOvr_enum);
  }
  else if (get_GbISP_TFCellVoltHiFltLv2_flg())
  {
    set_GeDCS_3513VoltFlt_enum(DCS_ONE_NUMB);
  }
  else
  {
    set_GeDCS_3513VoltFlt_enum(DCS_ZERO_NUMB);
  }

  DCS_DW.StateName = rtb_LogicalOperator2;
}

/* Model step function */
void DCS_BCL_50ms(void)
{
  real32_T tmp;
  if (CbDCS_3072ChrgVoltReqOvrSwt_flg)
  {
    set_GcDCS_3072ChrgVoltReq_V(CcDCS_3072ChrgVoltReqOvr_V);
  }
  else
  {
    tmp = fminf(fminf(get_GcDCC_DCChrgVoltRqst_V(), CcDCS_2819MaxVoltPermit_V),
                get_GcHDP_PackVolt_V() + CcDCS_3072ChrgVoltReqAdd_V) / 0.1F;
    if (tmp < 65536.0F)
    {
      if (tmp >= 0.0F)
      {
        set_GcDCS_3072ChrgVoltReq_V((uint16_T)tmp);
      }
      else
      {
        set_GcDCS_3072ChrgVoltReq_V(0U);
      }
    }
    else
    {
      set_GcDCS_3072ChrgVoltReq_V(MAX_uint16_T);
    }
  }

  if (CbDCS_3073ChrgCurReqOvrSwt_flg)
  {
    set_GcDCS_3073ChrgCurReq_A(CcDCS_3073ChrgCurReqOvr_A);
  }
  else
  {
    tmp = (get_GcDCC_DCChrgCrntRqst_A() * DCS_CONSTF1_NUMB + 400.0F) / 0.1F;
    if (tmp < 65536.0F)
    {
      if (tmp >= 0.0F)
      {
        set_GcDCS_3073ChrgCurReq_A((uint16_T)tmp);
      }
      else
      {
        set_GcDCS_3073ChrgCurReq_A(0U);
      }
    }
    else
    {
      set_GcDCS_3073ChrgCurReq_A(MAX_uint16_T);
    }
  }

  if (CbDCS_3074ChrgModeOvrSwt_flg)
  {
    set_GeDCS_3074ChrgMode_enum(CeDCS_3074ChrgModeOvr_enum);
  }
  else
  {
    set_GeDCS_3074ChrgMode_enum(CeDCS_3074ChrgMode_enum);
  }
}

/* Model step function */
void DCS_BHM_250ms(void)
{
  real32_T tmp;
  if (CbDCS_2601AlwMaxChrgVoltOvrSwt_flg)
  {
    set_GcDCS_2601AlwMaxChrgVolt_V(CcDCS_2601AlwMaxChrgVoltOvr_V);
  }
  else
  {
    tmp = CcDCS_2819MaxVoltPermit_V / 0.1F;
    if (tmp < 65536.0F)
    {
      if (tmp >= 0.0F)
      {
        set_GcDCS_2601AlwMaxChrgVolt_V((uint16_T)tmp);
      }
      else
      {
        set_GcDCS_2601AlwMaxChrgVolt_V(0U);
      }
    }
    else
    {
      set_GcDCS_2601AlwMaxChrgVolt_V(MAX_uint16_T);
    }
  }
}

/* Model step function */
void DCS_BRM_250ms(void)
{
  int32_T i;
  real32_T tmp;
  if (CbDCS_2565ChrgVerOvrSwt_flg)
  {
    set_GcDCS_2565ChrgVer_numb(CcDCS_2565ChrgVerOvr_numb);
  }
  else if (get_GbDCC_DCChrgVerSta_flg())
  {
    set_GcDCS_2565ChrgVer_numb(DCS_2565Ver_NUMB);
  }
  else
  {
    set_GcDCS_2565ChrgVer_numb(DCS_2565Ver_NUMB - DCS_ONE_NUMB);
  }

  if (CbDCS_2566BattTypeOvrSwt_flg)
  {
    set_GeDCS_2566BattType_enum(CeDCS_2566BattTypeOvr_enum);
  }
  else
  {
    set_GeDCS_2566BattType_enum(CeDCS_2566BattType_enum);
  }

  switch ((int32_T)get_GeUDS_CapSel_enum())
  {
   case Enum_UDSCapSel_Default:
    DCS_SwitchCaseActionSubsystem_h(&DCS_B.Merge_l);
    DC_SwitchCaseActionSubsystem_j2(&DCS_B.Merge);
    break;

   case Enum_UDSCapSel_CATL153Ah:
    DCS_SwitchCaseActionSubsystem_h(&DCS_B.Merge_l);
    DC_SwitchCaseActionSubsystem_j2(&DCS_B.Merge);
    break;

   case Enum_UDSCapSel_CATL180Ah:
    DCS_B.Merge_l = CcDCS_CATL180Ah2567BattCap_Ah;
    DCS_B.Merge = CcDCS_CATL180Ah2568BattVolt_V;
    break;

   case Enum_UDSCapSel_CATL177Ah:
    DCS_B.Merge_l = CcDCS_CATL177Ah2567BattCap_Ah;
    DCS_B.Merge = CcDCS_CATL177Ah2568BattVolt_V;
    break;

   case Enum_UDSCapSel_CATL203Ah:
    DCS_B.Merge_l = CcDCS_CATL203Ah2567BattCap_Ah;
    DCS_B.Merge = CcDCS_CATL203Ah2568BattVolt_V;
    break;

   case Enum_UDSCapSel_CATL51Ah:
    DCS_B.Merge_l = CcDCS_CATL51Ah2567BattCap_Ah;
    DCS_B.Merge = CcDCS_CATL51Ah2568BattVolt_V;
    break;

   case Enum_UDSCapSel_CATL132Ah:
    DCS_B.Merge_l = CcDCS_CATL132Ah2567BattCap_Ah;
    DCS_B.Merge = CcDCS_CATL132Ah2568BattVolt_V;
    break;

   case Enum_UDSCapSel_XWD75Ah:
    DCS_B.Merge_l = CcDCS_XWD75Ah2567BattCap_Ah;
    DCS_B.Merge = CcDCS_XWD75Ah2568BattVolt_V;
    break;

   case Enum_UDSCapSel_TFE177Ah:
    DCS_B.Merge_l = CcDCS_TFE177Ah2567BattCap_Ah;
    DCS_B.Merge = CcDCS_TFE177Ah2568BattVolt_V;
    break;

   case Enum_UDSCapSel_CATLCTP248Ah:
    DCS_B.Merge_l = CcDCS_CATLCTP248Ah2567BattCap_Ah;
    DCS_B.Merge = CcDCS_CATLCTP248Ah2568BattVolt_V;
    break;
  }

  if (CbDCS_2567BattCapOvrSwt_flg)
  {
    set_GcDCS_2567BattCap_Ah(CcDCS_2567BattCapOvr_Ah);
  }
  else
  {
    tmp = DCS_B.Merge_l / 0.1F;
    if (tmp < 65536.0F)
    {
      if (tmp >= 0.0F)
      {
        set_GcDCS_2567BattCap_Ah((uint16_T)tmp);
      }
      else
      {
        set_GcDCS_2567BattCap_Ah(0U);
      }
    }
    else
    {
      set_GcDCS_2567BattCap_Ah(MAX_uint16_T);
    }
  }

  if (CbDCS_2568BattVoltOvrSwt_flg)
  {
    set_GcDCS_2568BattVolt_V(CcDCS_2568BattVoltOvr_V);
  }
  else
  {
    tmp = DCS_B.Merge / 0.1F;
    if (tmp < 65536.0F)
    {
      if (tmp >= 0.0F)
      {
        set_GcDCS_2568BattVolt_V((uint16_T)tmp);
      }
      else
      {
        set_GcDCS_2568BattVolt_V(0U);
      }
    }
    else
    {
      set_GcDCS_2568BattVolt_V(MAX_uint16_T);
    }
  }

  if (CbDCS_2569BattFctyNameOvrSwt_flg)
  {
    set_GaDCS_2569BattFctyName_numb( 0 , CaDCS_2569BattFctyNameOvr_numb[0]);
    set_GaDCS_2569BattFctyName_numb( 1 , CaDCS_2569BattFctyNameOvr_numb[1]);
    set_GaDCS_2569BattFctyName_numb( 2 , CaDCS_2569BattFctyNameOvr_numb[2]);
    set_GaDCS_2569BattFctyName_numb( 3 , CaDCS_2569BattFctyNameOvr_numb[3]);
  }
  else
  {
    set_GaDCS_2569BattFctyName_numb( 0 , CaDCS_2569BattFctyName_numb[0]);
    set_GaDCS_2569BattFctyName_numb( 1 , CaDCS_2569BattFctyName_numb[1]);
    set_GaDCS_2569BattFctyName_numb( 2 , CaDCS_2569BattFctyName_numb[2]);
    set_GaDCS_2569BattFctyName_numb( 3 , CaDCS_2569BattFctyName_numb[3]);
  }

  if (CbDCS_2570BattSerOvrSwt_flg)
  {
    set_GcDCS_2570BattSer_numb(CcDCS_2570BattSerOvr_numb);
  }
  else
  {
    set_GcDCS_2570BattSer_numb(CcDCS_2570BattSer_numb);
  }

  if (CbDCS_2571BattPrdctDayOvrSwt_flg)
  {
    set_GcDCS_2571BattPrdctDay_D(CcDCS_2571BattPrdctDayOvr_D);
  }
  else
  {
    set_GcDCS_2571BattPrdctDay_D(CcDCS_2571BattPrdctDay_D);
  }

  if (CbDCS_2571BattPrdctMonOvrSwt_flg)
  {
    set_GcDCS_2571BattPrdctMon_M(CcDCS_2571BattPrdctMonOvr_M);
  }
  else
  {
    set_GcDCS_2571BattPrdctMon_M(CcDCS_2571BattPrdctMon_M);
  }

  if (CbDCS_2571BattPrdctYrOvrSwt_flg)
  {
    set_GcDCS_2571BattPrdctYr_Y(CcDCS_2571BattPrdctYrOvr_Y);
  }
  else if (CcDCS_2571BattPrdctYr_Y - 1985.0F < 256.0F)
  {
    if (CcDCS_2571BattPrdctYr_Y - 1985.0F >= 0.0F)
    {
      set_GcDCS_2571BattPrdctYr_Y((uint8_T)(CcDCS_2571BattPrdctYr_Y - 1985.0F));
    }
    else
    {
      set_GcDCS_2571BattPrdctYr_Y(0U);
    }
  }
  else
  {
    set_GcDCS_2571BattPrdctYr_Y(MAX_uint8_T);
  }

  if (CbDCS_2572BattChrgCtOvrSwt_flg)
  {
    set_GcDCS_2572BattChrgCt_numb(CcDCS_2572BattChrgCtOvr_numb);
  }
  else
  {
    set_GcDCS_2572BattChrgCt_numb(CcDCS_2572BattChrgCt_numb);
  }

  if (CbDCS_2573BattPrptyOvrSwt_flg)
  {
    set_GeDCS_2573BattPrpty_enum(CeDCS_2573BattPrptyOvr_enum);
  }
  else
  {
    set_GeDCS_2573BattPrpty_enum(CeDCS_2573BattPrpty_enum);
  }

  if (CbDCS_2574ResvOvrSwt_flg)
  {
    set_GcDCS_2574Resv_numb(CcDCS_2574ResvOvr_numb);
  }
  else
  {
    set_GcDCS_2574Resv_numb(CcDCS_2574Resv_numb);
  }

  for (i = 0; i < 17; i++)
  {
    if (CbDCS_2575VINOvrSwt_flg)
    {
      set_GaDCS_2575VIN_numb( i , CaDCS_2575VINOvr_numb);
    }
    else
    {
      set_GaDCS_2575VIN_numb( i , 0U);
    }
  }

  for (i = 0; i < 8; i++)
  {
    if (CbDCS_2576SoftVerOvrSwt_flg)
    {
      set_GaDCS_2576SoftVer_numb( i , CaDCS_2576SoftVerOvr_numb);
    }
    else
    {
      set_GaDCS_2576SoftVer_numb( i , CaDCS_2576SoftVer_numb[i]);
    }
  }

  DCS_Y.GaDCS_2569BattFctyName_numb[0] = get_GaDCS_2569BattFctyName_numb( 0 );
  DCS_Y.GaDCS_2569BattFctyName_numb[1] = get_GaDCS_2569BattFctyName_numb( 1 );
  DCS_Y.GaDCS_2569BattFctyName_numb[2] = get_GaDCS_2569BattFctyName_numb( 2 );
  DCS_Y.GaDCS_2569BattFctyName_numb[3] = get_GaDCS_2569BattFctyName_numb( 3 );
  for (i = 0; i < 17; i++)
  {
    DCS_Y.GaDCS_2575VIN_numb[i] = get_GaDCS_2575VIN_numb( i );
  }

  for (i = 0; i < 8; i++)
  {
    DCS_Y.GaDCS_2576SoftVer_numb[i] = get_GaDCS_2576SoftVer_numb( i );
  }
}

/* Model step function */
void DCS_BRO_250ms(void)
{
  if (CbDCS_2829DaOvrSwt_flg)
  {
    set_GcDCS_2829Da_numb(CcDCS_2829DaOvr_numb);
  }
  else if ((get_GeCTC_CtrCtlState_enum() == (int32_T)Enum_CTCCtrCtlState_Online)
           && (get_GeCTC_CtrCtlConnMode_enum() == (int32_T)
               Enum_CTCCtrCtlConnMode_DCChrg))
  {
    set_GcDCS_2829Da_numb(DCS_BROAA_NUMB);
  }
  else
  {
    set_GcDCS_2829Da_numb(DCS_ZERO_NUMB);
  }
}

/* Model step function */
void DCS_BCS_250ms(void)
{
  int32_T tmp;
  real32_T tmp_0;
  uint8_T tmp_1;
  if (CbDCS_3075ChrgVoltMeaOvrSwt_flg)
  {
    set_GcDCS_3075ChrgVoltMea_V(CcDCS_3075ChrgVoltMeaOvr_V);
  }
  else
  {
    tmp_0 = get_GcHDP_PackVolt_V() / 0.1F;
    if (tmp_0 < 65536.0F)
    {
      if (tmp_0 >= 0.0F)
      {
        set_GcDCS_3075ChrgVoltMea_V((uint16_T)tmp_0);
      }
      else
      {
        set_GcDCS_3075ChrgVoltMea_V(0U);
      }
    }
    else
    {
      set_GcDCS_3075ChrgVoltMea_V(MAX_uint16_T);
    }
  }

  if (CbDCS_3076ChrgCurMeaOvrSwt_flg)
  {
    set_GcDCS_3076ChrgCurMea_A(CcDCS_3076ChrgCurMeaOvr_A);
  }
  else
  {
    tmp_0 = (get_GcHDP_PackCrnt_A() + 400.0F) / 0.1F;
    if (tmp_0 < 65536.0F)
    {
      if (tmp_0 >= 0.0F)
      {
        set_GcDCS_3076ChrgCurMea_A((uint16_T)tmp_0);
      }
      else
      {
        set_GcDCS_3076ChrgCurMea_A(0U);
      }
    }
    else
    {
      set_GcDCS_3076ChrgCurMea_A(MAX_uint16_T);
    }
  }

  if (CbDCS_3077MaxCellVoltOvrSwt_flg)
  {
    set_GcDCS_3077MaxCellVolt_V(CcDCS_3077MaxCellVoltOvr_V);
  }
  else
  {
    tmp_0 = (real32_T)get_GcCDP_MaxCellVolt_mV() / (real32_T)DCS_THOUSAND_NUMB /
      0.01F;
    if (tmp_0 < 65536.0F)
    {
      if (tmp_0 >= 0.0F)
      {
        set_GcDCS_3077MaxCellVolt_V((uint16_T)tmp_0);
      }
      else
      {
        set_GcDCS_3077MaxCellVolt_V(0U);
      }
    }
    else
    {
      set_GcDCS_3077MaxCellVolt_V(MAX_uint16_T);
    }
  }

  if (CbDCS_3077MaxCellVoltGrpOvrSwt_flg)
  {
    set_GcDCS_3077MaxCellVoltGrp_numb(CcDCS_3077MaxCellVoltGrpOvr_numb);
  }
  else
  {
    tmp = get_GcCDP_MaxCellVoltNumb_numb() - DCS_ONE_NUMB;
    if (tmp < 0)
    {
      tmp = 0;
    }

    tmp_0 = (real32_T)tmp / (real32_T)CcDCS_CMUQnty_numb;
    if (tmp_0 < 256.0F)
    {
      if (tmp_0 >= 0.0F)
      {
        tmp_1 = (uint8_T)tmp_0;
      }
      else
      {
        tmp_1 = 0U;
      }
    }
    else
    {
      tmp_1 = MAX_uint8_T;
    }

    set_GcDCS_3077MaxCellVoltGrp_numb((uint8_T)((uint32_T)tmp_1 + DCS_ONE_NUMB));
  }

  if (CbDCS_3078SOCOvrSwt_flg)
  {
    set_GcDCS_3078SOC_pct(CcDCS_3078SOCOvr_pct);
  }
  else if (get_GcSOC_DispSOC_pct() < 256.0F)
  {
    if (get_GcSOC_DispSOC_pct() >= 0.0F)
    {
      set_GcDCS_3078SOC_pct((uint8_T)get_GcSOC_DispSOC_pct());
    }
    else
    {
      set_GcDCS_3078SOC_pct(0U);
    }
  }
  else
  {
    set_GcDCS_3078SOC_pct(MAX_uint8_T);
  }

  if (CbDCS_3079TiRemainOvrSwt_flg)
  {
    set_GcDCS_3079TiRemain_min(CcDCS_3079TiRemainOvr_min);
  }
  else if (get_GcDCC_ChrgingTiRem_min() < 600)
  {
    set_GcDCS_3079TiRemain_min(get_GcDCC_ChrgingTiRem_min());
  }
  else
  {
    set_GcDCS_3079TiRemain_min(600U);
  }
}

/* Model step function */
void DCS_BSM_250ms(void)
{
  if (CbDCS_3085MaxCellVoltIndexOvrSwt_flg)
  {
    set_GcDCS_3085MaxCellVoltIndex_numb(CcDCS_3085MaxCellVoltIndexOvr_numb);
  }
  else
  {
    set_GcDCS_3085MaxCellVoltIndex_numb((uint8_T)(get_GcCDP_MaxCellVoltNumb_numb
      () + -1));
  }

  if (CbDCS_3086MaxTempOvrSwt_flg)
  {
    set_GcDCS_3086MaxTemp_C(CcDCS_3086MaxTempOvr_C);
  }
  else if (get_GcCDP_MaxCellTemp_C() + 50.0F < 256.0F)
  {
    if (get_GcCDP_MaxCellTemp_C() + 50.0F >= 0.0F)
    {
      set_GcDCS_3086MaxTemp_C((uint8_T)(get_GcCDP_MaxCellTemp_C() + 50.0F));
    }
    else
    {
      set_GcDCS_3086MaxTemp_C(0U);
    }
  }
  else
  {
    set_GcDCS_3086MaxTemp_C(MAX_uint8_T);
  }

  if (CbDCS_3087MaxTempIndexOvrSwt_flg)
  {
    set_GcDCS_3087MaxTempIndex_numb(CcDCS_3087MaxTempIndexOvr_numb);
  }
  else
  {
    set_GcDCS_3087MaxTempIndex_numb((uint8_T)(get_GcCDP_MaxCellTempNumb_numb() +
      -1));
  }

  if (CbDCS_3088MinTempOvrSwt_flg)
  {
    set_GcDCS_3088MinTemp_C(CcDCS_3088MinTempOvr_C);
  }
  else if (get_GcCDP_MinCellTemp_C() + 50.0F < 256.0F)
  {
    if (get_GcCDP_MinCellTemp_C() + 50.0F >= 0.0F)
    {
      set_GcDCS_3088MinTemp_C((uint8_T)(get_GcCDP_MinCellTemp_C() + 50.0F));
    }
    else
    {
      set_GcDCS_3088MinTemp_C(0U);
    }
  }
  else
  {
    set_GcDCS_3088MinTemp_C(MAX_uint8_T);
  }

  if (CbDCS_3089MinTempIndexOvrSwt_flg)
  {
    set_GcDCS_3089MinTempIndex_numb(CcDCS_3089MinTempIndexOvr_numb);
  }
  else
  {
    set_GcDCS_3089MinTempIndex_numb((uint8_T)(get_GcCDP_MinCellTempNumb_numb() +
      -1));
  }

  if (CbDCS_3090CellVoltWarnOvrSwt_flg)
  {
    set_GeDCS_3090CellVoltWarn_enum(CeDCS_3090CellVoltWarnOvr_enum);
  }
  else
  {
    set_GeDCS_3090CellVoltWarn_enum(DCS_ZERO_NUMB);
  }

  if (CbDCS_3091SOCWarnOvrSwt_flg)
  {
    set_GeDCS_3091SOCWarn_enum(CeDCS_3091SOCWarnOvr_enum);
  }
  else
  {
    set_GeDCS_3091SOCWarn_enum(DCS_ZERO_NUMB);
  }

  if (CbDCS_3092CurWarnOvrSwt_flg)
  {
    set_GeDCS_3092CurWarn_enum(CeDCS_3092CurWarnOvr_enum);
  }
  else
  {
    set_GeDCS_3092CurWarn_enum(DCS_ZERO_NUMB);
  }

  if (CbDCS_3093TempWarnOvrSwt_flg)
  {
    set_GeDCS_3093TempWarn_enum(CeDCS_3093TempWarnOvr_enum);
  }
  else
  {
    set_GeDCS_3093TempWarn_enum(DCS_ZERO_NUMB);
  }

  if (CbDCS_3094IsoStateOvrSwt_flg)
  {
    set_GeDCS_3094IsoState_enum(CeDCS_3094IsoStateOvr_enum);
  }
  else
  {
    set_GeDCS_3094IsoState_enum(DCS_ZERO_NUMB);
  }

  if (CbDCS_3095OutContStOvrSwt_flg)
  {
    set_GeDCS_3095OutContSt_enum(CeDCS_3095OutContStOvr_enum);
  }
  else
  {
    set_GeDCS_3095OutContSt_enum(DCS_ZERO_NUMB);
  }

  if (CbDCS_3096BMSChrgRdyOvrSwt_flg)
  {
    set_GeDCS_3096BMSChrgRdy_enum(CeDCS_3096BMSChrgRdyOvr_enum);
  }
  else
  {
    set_GeDCS_3096BMSChrgRdy_enum(DCS_ONE_NUMB);
  }
}

/* Model step function */
void DCS_BSD_250ms(void)
{
  real32_T tmp;
  if (CbDCS_3601SOCFinalOvrSwt_flg)
  {
    set_GcDCS_3601SOCFinal_pct(CcDCS_3601SOCFinalOvr_pct);
  }
  else if (get_GcSOC_DispSOC_pct() < 256.0F)
  {
    if (get_GcSOC_DispSOC_pct() >= 0.0F)
    {
      set_GcDCS_3601SOCFinal_pct((uint8_T)get_GcSOC_DispSOC_pct());
    }
    else
    {
      set_GcDCS_3601SOCFinal_pct(0U);
    }
  }
  else
  {
    set_GcDCS_3601SOCFinal_pct(MAX_uint8_T);
  }

  if (CbDCS_3602MinCellVoltOvrSwt_flg)
  {
    set_GcDCS_3602MinCellVolt_V(CcDCS_3602MinCellVoltOvr_V);
  }
  else
  {
    tmp = (real32_T)get_GcCDP_MinCellVolt_mV() / (real32_T)DCS_THOUSAND_NUMB /
      0.01F;
    if (tmp < 65536.0F)
    {
      if (tmp >= 0.0F)
      {
        set_GcDCS_3602MinCellVolt_V((uint16_T)tmp);
      }
      else
      {
        set_GcDCS_3602MinCellVolt_V(0U);
      }
    }
    else
    {
      set_GcDCS_3602MinCellVolt_V(MAX_uint16_T);
    }
  }

  if (CbDCS_3603MaxCellVoltOvrSwt_flg)
  {
    set_GcDCS_3603MaxCellVolt_V(CcDCS_3603MaxCellVoltOvr_V);
  }
  else
  {
    tmp = (real32_T)get_GcCDP_MaxCellVolt_mV() / (real32_T)DCS_THOUSAND_NUMB /
      0.01F;
    if (tmp < 65536.0F)
    {
      if (tmp >= 0.0F)
      {
        set_GcDCS_3603MaxCellVolt_V((uint16_T)tmp);
      }
      else
      {
        set_GcDCS_3603MaxCellVolt_V(0U);
      }
    }
    else
    {
      set_GcDCS_3603MaxCellVolt_V(MAX_uint16_T);
    }
  }

  if (CbDCS_3604MinCellTempOvrSwt_flg)
  {
    set_GcDCS_3604MinCellTemp_C(CcDCS_3604MinCellTempOvr_C);
  }
  else if (get_GcCDP_MinCellTemp_C() + 50.0F < 256.0F)
  {
    if (get_GcCDP_MinCellTemp_C() + 50.0F >= 0.0F)
    {
      set_GcDCS_3604MinCellTemp_C((uint8_T)(get_GcCDP_MinCellTemp_C() + 50.0F));
    }
    else
    {
      set_GcDCS_3604MinCellTemp_C(0U);
    }
  }
  else
  {
    set_GcDCS_3604MinCellTemp_C(MAX_uint8_T);
  }

  if (CbDCS_3605MaxCellTempOvrSwt_flg)
  {
    set_GcDCS_3605MaxCellTemp_C(CcDCS_3605MaxCellTempOvr_C);
  }
  else if (get_GcCDP_MaxCellTemp_C() + 50.0F < 256.0F)
  {
    if (get_GcCDP_MaxCellTemp_C() + 50.0F >= 0.0F)
    {
      set_GcDCS_3605MaxCellTemp_C((uint8_T)(get_GcCDP_MaxCellTemp_C() + 50.0F));
    }
    else
    {
      set_GcDCS_3605MaxCellTemp_C(0U);
    }
  }
  else
  {
    set_GcDCS_3605MaxCellTemp_C(MAX_uint8_T);
  }
}

/* Model step function */
void DCS_BEM_250ms(void)
{
  if (CbDCS_3901ToutCRM00OvrSwt_flg)
  {
    set_GeDCS_3901ToutCRM00_enum(CeDCS_3901ToutCRM00Ovr_enum);
  }
  else if (get_GbDCC_CRM00Tout_flg())
  {
    set_GeDCS_3901ToutCRM00_enum(DCS_ONE_NUMB);
  }
  else
  {
    set_GeDCS_3901ToutCRM00_enum(DCS_ZERO_NUMB);
  }

  if (CbDCS_3902ToutCRMAAOvrSwt_flg)
  {
    set_GeDCS_3902ToutCRMAA_enum(CeDCS_3902ToutCRMAAOvr_enum);
  }
  else if (get_GbDCC_CRMAATout_flg())
  {
    set_GeDCS_3902ToutCRMAA_enum(DCS_ONE_NUMB);
  }
  else
  {
    set_GeDCS_3902ToutCRMAA_enum(DCS_ZERO_NUMB);
  }

  if (CbDCS_3903ToutCMLOvrSwt_flg)
  {
    set_GeDCS_3903ToutCML_enum(CeDCS_3903ToutCMLOvr_enum);
  }
  else if (get_GbDCC_CMLTout_flg())
  {
    set_GeDCS_3903ToutCML_enum(DCS_ONE_NUMB);
  }
  else
  {
    set_GeDCS_3903ToutCML_enum(DCS_ZERO_NUMB);
  }

  if (CbDCS_3904ToutCROAAOvrSwt_flg)
  {
    set_GeDCS_3904ToutCROAA_enum(CeDCS_3904ToutCROAAOvr_enum);
  }
  else if (get_GbDCC_CROAATout_flg() || get_GbDCC_CROTout_flg())
  {
    set_GeDCS_3904ToutCROAA_enum(DCS_ONE_NUMB);
  }
  else
  {
    set_GeDCS_3904ToutCROAA_enum(DCS_ZERO_NUMB);
  }

  if (CbDCS_3905ToutCCSOvrSwt_flg)
  {
    set_GeDCS_3905ToutCCS_enum(CeDCS_3905ToutCCSOvr_enum);
  }
  else if (get_GbDCC_CCSTout_flg())
  {
    set_GeDCS_3905ToutCCS_enum(DCS_ONE_NUMB);
  }
  else
  {
    set_GeDCS_3905ToutCCS_enum(DCS_ZERO_NUMB);
  }

  if (CbDCS_3906ToutCSTOvrSwt_flg)
  {
    set_GeDCS_3906ToutCST_enum(CeDCS_3906ToutCSTOvr_enum);
  }
  else if (get_GbDCC_CSTTout_flg())
  {
    set_GeDCS_3906ToutCST_enum(DCS_ONE_NUMB);
  }
  else
  {
    set_GeDCS_3906ToutCST_enum(DCS_ZERO_NUMB);
  }

  if (CbDCS_3907ToutCSDOvrSwt_flg)
  {
    set_GeDCS_3907ToutCSD_enum(CeDCS_3907ToutCSDOvr_enum);
  }
  else if (get_GbDCC_CSDTout_flg())
  {
    set_GeDCS_3907ToutCSD_enum(DCS_ONE_NUMB);
  }
  else
  {
    set_GeDCS_3907ToutCSD_enum(DCS_ZERO_NUMB);
  }

  if (CbDCS_BEMOtherOvrSwt_flg)
  {
    set_GcDCS_BEMOther_numb(CcDCS_BEMOtherOvr_numb);
  }
  else
  {
    set_GcDCS_BEMOther_numb(DCS_ZERO_NUMB);
  }
}

/* Model step function */
void DCS_BCP_500ms(void)
{
  uint32_T tmp;
  real32_T tmp_0;
  if (CbDCS_2816MaxCellVoltPermitOvrSwt_flg)
  {
    set_GcDCS_2816MaxCellVoltPermit_V(CcDCS_2816MaxCellVoltPermitOvr_V);
  }
  else
  {
    set_GcDCS_2816MaxCellVoltPermit_V(((real32_T)get_GcUDS_FullChrgCutoffVolt_mV
      () + CcDCS_2816MaxCellVoltPermitAdd_mV) / (real32_T)DCS_TEN_NUMB);
  }

  switch ((int32_T)get_GeUDS_CapSel_enum())
  {
   case Enum_UDSCapSel_Default:
    DCS_SwitchCaseActionSubsystem(&DCS_B.Merge_g);
    DCS_SwitchCaseActionSubsystem_j(&DCS_B.Merge_a);
    break;

   case Enum_UDSCapSel_CATL153Ah:
    DCS_SwitchCaseActionSubsystem(&DCS_B.Merge_g);
    DCS_SwitchCaseActionSubsystem_j(&DCS_B.Merge_a);
    break;

   case Enum_UDSCapSel_CATL180Ah:
    DCS_B.Merge_g = CcDCS_CATL180Ah2817MaxCurPermit_A;
    DCS_B.Merge_a = CcDCS_CATL180Ah2819MaxVoltPermit_V;
    break;

   case Enum_UDSCapSel_CATL177Ah:
    DCS_B.Merge_g = CcDCS_CATL177Ah2817MaxCurPermit_A;
    DCS_B.Merge_a = CcDCS_CATL177Ah2819MaxVoltPermit_V;
    break;

   case Enum_UDSCapSel_CATL203Ah:
    DCS_B.Merge_g = CcDCS_CATL203Ah2817MaxCurPermit_A;
    DCS_B.Merge_a = CcDCS_CATL203Ah2819MaxVoltPermit_V;
    break;

   case Enum_UDSCapSel_CATL51Ah:
    DCS_B.Merge_g = CcDCS_CATL51Ah2817MaxCurPermit_A;
    DCS_B.Merge_a = CcDCS_CATL51Ah2819MaxVoltPermit_V;
    break;

   case Enum_UDSCapSel_CATL132Ah:
    DCS_B.Merge_g = CcDCS_CATL132Ah2817MaxCurPermit_A;
    DCS_B.Merge_a = CcDCS_CATL132Ah2819MaxVoltPermit_V;
    break;

   case Enum_UDSCapSel_XWD75Ah:
    DCS_B.Merge_g = CcDCS_XWD75Ah2817MaxCurPermit_A;
    DCS_B.Merge_a = CcDCS_XWD75Ah2819MaxVoltPermit_V;
    break;

   case Enum_UDSCapSel_TFE177Ah:
    DCS_B.Merge_g = CcDCS_TFE177Ah2817MaxCurPermit_A;
    DCS_B.Merge_a = CcDCS_TFE177Ah2819MaxVoltPermit_V;
    break;

   case Enum_UDSCapSel_CATLCTP248Ah:
    DCS_B.Merge_g = CcDCS_CATLCTP248Ah2817MaxCurPermit_A;
    DCS_B.Merge_a = CcDCS_CATLCTP248Ah2819MaxVoltPermit_V;
    break;
  }

  if (CbDCS_2817MaxCurPermitOvrSwt_flg)
  {
    set_GcDCS_2817MaxCurPermit_A(CcDCS_2817MaxCurPermitOvr_A);
  }
  else
  {
    tmp_0 = (DCS_B.Merge_g + 400.0F) / 0.1F;
    if (tmp_0 < 65536.0F)
    {
      if (tmp_0 >= 0.0F)
      {
        set_GcDCS_2817MaxCurPermit_A((uint16_T)tmp_0);
      }
      else
      {
        set_GcDCS_2817MaxCurPermit_A(0U);
      }
    }
    else
    {
      set_GcDCS_2817MaxCurPermit_A(MAX_uint16_T);
    }
  }

  if (CbDCS_2819MaxVoltPermitOvrSwt_flg)
  {
    set_GcDCS_2819MaxVoltPermit_V(CcDCS_2819MaxVoltPermitOvr_V);
  }
  else
  {
    tmp_0 = DCS_B.Merge_a / 0.1F;
    if (tmp_0 < 65536.0F)
    {
      if (tmp_0 >= 0.0F)
      {
        set_GcDCS_2819MaxVoltPermit_V((uint16_T)tmp_0);
      }
      else
      {
        set_GcDCS_2819MaxVoltPermit_V(0U);
      }
    }
    else
    {
      set_GcDCS_2819MaxVoltPermit_V(MAX_uint16_T);
    }
  }

  if (CbDCS_2818RateEgyOvrSwt_flg)
  {
    set_GcDCS_2818RateEgy_Kwh(CcDCS_2818RateEgyOvr_Kwh);
  }
  else
  {
    tmp = get_GcUDS_BatEnergy_kWh() * 10U;
    if (tmp > 65535U)
    {
      tmp = 65535U;
    }

    set_GcDCS_2818RateEgy_Kwh((uint16_T)tmp);
  }

  if (CbDCS_2820MaxTempPermitOvrSwt_flg)
  {
    set_GcDCS_2820MaxTempPermit_C(CcDCS_2820MaxTempPermitOvr_C);
  }
  else if (CcDCS_2820MaxTempPermit_C + 50.0F < 256.0F)
  {
    if (CcDCS_2820MaxTempPermit_C + 50.0F >= 0.0F)
    {
      set_GcDCS_2820MaxTempPermit_C((uint8_T)(CcDCS_2820MaxTempPermit_C + 50.0F));
    }
    else
    {
      set_GcDCS_2820MaxTempPermit_C(0U);
    }
  }
  else
  {
    set_GcDCS_2820MaxTempPermit_C(MAX_uint8_T);
  }

  if (CbDCS_2821SOCOvrSwt_flg)
  {
    set_GcDCS_2821SOC_pct(CcDCS_2821SOCOvr_pct);
  }
  else
  {
    tmp_0 = get_GcSOC_DispSOC_pct() / 0.1F;
    if (tmp_0 < 65536.0F)
    {
      if (tmp_0 >= 0.0F)
      {
        set_GcDCS_2821SOC_pct((uint16_T)tmp_0);
      }
      else
      {
        set_GcDCS_2821SOC_pct(0U);
      }
    }
    else
    {
      set_GcDCS_2821SOC_pct(MAX_uint16_T);
    }
  }

  if (CbDCS_2822PackVoltOvrSwt_flg)
  {
    set_GcDCS_2822PackVolt_V(CcDCS_2822PackVoltOvr_V);
  }
  else
  {
    tmp_0 = get_GcHDP_PackVolt_V() / 0.1F;
    if (tmp_0 < 65536.0F)
    {
      if (tmp_0 >= 0.0F)
      {
        set_GcDCS_2822PackVolt_V((uint16_T)tmp_0);
      }
      else
      {
        set_GcDCS_2822PackVolt_V(0U);
      }
    }
    else
    {
      set_GcDCS_2822PackVolt_V(MAX_uint16_T);
    }
  }
}

/* Model initialize function */
void DCS_initialize(void)
{
  set_GcDCS_3073ChrgCurReq_A(4000U);
  set_GcDCS_2571BattPrdctYr_Y(0U);
  set_GcDCS_3076ChrgCurMea_A(4000U);
  set_GcDCS_3085MaxCellVoltIndex_numb(0U);
  set_GcDCS_3086MaxTemp_C(50U);
  set_GcDCS_3087MaxTempIndex_numb(0U);
  set_GcDCS_3088MinTemp_C(50U);
  set_GcDCS_3089MinTempIndex_numb(0U);
  set_GcDCS_3604MinCellTemp_C(50U);
  set_GcDCS_3605MaxCellTemp_C(50U);
  set_GcDCS_2817MaxCurPermit_A(4000U);
  set_GcDCS_2820MaxTempPermit_C(50U);
}

/*
 * File trailer for generated code.
 *
 * [EOF]
 */
